/*
 * Decompiled with CFR 0.152.
 */
package bblsom.handlers;

import bblsom.BBLSOhMy;
import bblsom.blocks.CustomBlockButton;
import bblsom.blocks.CustomBlockDirt;
import bblsom.blocks.CustomBlockDoor;
import bblsom.blocks.CustomBlockFallingDirt;
import bblsom.blocks.CustomBlockFarmland;
import bblsom.blocks.CustomBlockGrass;
import bblsom.blocks.CustomBlockHoney;
import bblsom.blocks.CustomBlockLeaves;
import bblsom.blocks.CustomBlockLever;
import bblsom.blocks.CustomBlockLitter;
import bblsom.blocks.CustomBlockMushroom;
import bblsom.blocks.CustomBlockPressurePlate;
import bblsom.blocks.CustomBlockPressurePlateWeighted;
import bblsom.blocks.CustomBlockStandingSign;
import bblsom.blocks.CustomBlockTrapDoor;
import bblsom.blocks.CustomBlockWallSign;
import bblsom.entity.CustomEntityBoat;
import bblsom.handlers.ForgeConfigHandler;
import bblsom.item.CustomItemBoat;
import bblsom.item.CustomItemHorseArmor;
import bblsom.item.CustomItemSign;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="bblsom")
public class ModRegistry {
    public static final List<Item> ITEMS_BUTTONS = new ArrayList<Item>();
    public static final List<Item> ITEMS_LEVERS = new ArrayList<Item>();
    public static final List<Item> ITEMS_SIGNS = new ArrayList<Item>();
    public static final List<Item> ITEMS_HONEY = new ArrayList<Item>();
    public static final List<Item> ITEMS_DOORS = new ArrayList<Item>();
    public static final List<Item> ITEMS_TRAPDOORS = new ArrayList<Item>();
    public static final List<Item> ITEMS_PRESSUREPLATES = new ArrayList<Item>();
    public static final List<Item> ITEMS_PRESSUREPLATESWEIGHTED = new ArrayList<Item>();
    public static final List<Item> ITEMS_DIRT = new ArrayList<Item>();
    public static final List<Item> ITEMS_FALLINGDIRT = new ArrayList<Item>();
    public static final List<Item> ITEMS_GRASS = new ArrayList<Item>();
    public static final List<Item> ITEMS_FARMLAND = new ArrayList<Item>();
    public static final List<Item> ITEMS_LEAVES = new ArrayList<Item>();
    public static final List<Item> ITEMS_MUSHROOM = new ArrayList<Item>();
    public static final List<Item> ITEMS_HUGEMUSHROOM = new ArrayList<Item>();
    public static final List<Item> ITEMS_LITTER = new ArrayList<Item>();
    public static final List<CustomItemBoat> ITEMS_BOATS = new ArrayList<CustomItemBoat>();
    public static final List<Item> ITEMS_HORSEARMOR = new ArrayList<Item>();
    public static final List<Block> BLOCKS_BUTTONS = new ArrayList<Block>();
    public static final List<Block> BLOCKS_LEVERS = new ArrayList<Block>();
    public static final List<Block> BLOCKS_SIGNS = new ArrayList<Block>();
    public static final List<Block> BLOCKS_HONEY = new ArrayList<Block>();
    public static final List<Block> BLOCKS_DOORS = new ArrayList<Block>();
    public static final List<Block> BLOCKS_TRAPDOORS = new ArrayList<Block>();
    public static final List<Block> BLOCKS_PRESSUREPLATES = new ArrayList<Block>();
    public static final List<Block> BLOCKS_PRESSUREPLATESWEIGHTED = new ArrayList<Block>();
    public static final List<Block> BLOCKS_DIRT = new ArrayList<Block>();
    public static final List<Block> BLOCKS_FALLINGDIRT = new ArrayList<Block>();
    public static final List<Block> BLOCKS_GRASS = new ArrayList<Block>();
    public static final List<Block> BLOCKS_FARMLAND = new ArrayList<Block>();
    public static final List<Block> BLOCKS_LEAVES = new ArrayList<Block>();
    public static final List<Block> BLOCKS_MUSHROOM = new ArrayList<Block>();
    public static final List<Block> BLOCKS_HUGEMUSHROOM = new ArrayList<Block>();
    public static final List<Block> BLOCKS_LITTER = new ArrayList<Block>();
    public static final SoundEvent BLOCK_HONEY_SLIDE = (SoundEvent)new SoundEvent(new ResourceLocation("bblsom", "block_honey_slide")).setRegistryName("block_honey_slide");
    public static final SoundEvent BLOCK_HONEY_BREAK = (SoundEvent)new SoundEvent(new ResourceLocation("bblsom", "block_honey_break")).setRegistryName("block_honey_break");
    public static final SoundEvent BLOCK_HONEY_STEP = (SoundEvent)new SoundEvent(new ResourceLocation("bblsom", "block_honey_step")).setRegistryName("block_honey_step");
    public static final SoundEvent BLOCK_HONEY_PLACE = (SoundEvent)new SoundEvent(new ResourceLocation("bblsom", "block_honey_place")).setRegistryName("block_honey_place");
    public static final SoundEvent BLOCK_HONEY_HIT = (SoundEvent)new SoundEvent(new ResourceLocation("bblsom", "block_honey_hit")).setRegistryName("block_honey_hit");
    public static final SoundEvent BLOCK_HONEY_FALL = (SoundEvent)new SoundEvent(new ResourceLocation("bblsom", "block_honey_fall")).setRegistryName("block_honey_fall");
    public static final SoundType BLOCK_HONEY_TYPE = new SoundType(1.0f, 1.0f, BLOCK_HONEY_BREAK, BLOCK_HONEY_STEP, BLOCK_HONEY_PLACE, BLOCK_HONEY_HIT, BLOCK_HONEY_FALL);

    public static void init() {
        SoundType soundType;
        Material material;
        String name;
        String name2;
        String[] args;
        for (String entry : ForgeConfigHandler.server.customButtons) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                boolean wooden = Boolean.parseBoolean(args[1].trim());
                int tickrate = Integer.parseInt(args[2].trim());
                BLOCKS_BUTTONS.add((Block)new CustomBlockButton(name2, wooden, tickrate));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse button entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customLevers) {
            name = entry.trim();
            if (name.isEmpty()) continue;
            BLOCKS_LEVERS.add((Block)new CustomBlockLever(name));
        }
        for (String entry : ForgeConfigHandler.server.customSigns) {
            name = entry.trim();
            if (name.isEmpty()) continue;
            CustomItemSign itemSign = new CustomItemSign(name);
            CustomBlockWallSign blockWallSign = new CustomBlockWallSign(name, (Item)itemSign);
            CustomBlockStandingSign blockStandingSign = new CustomBlockStandingSign(name, (Item)itemSign);
            itemSign.setWallSign((Block)blockWallSign);
            itemSign.setStandingSign((Block)blockStandingSign);
            ITEMS_SIGNS.add((Item)itemSign);
            BLOCKS_SIGNS.add((Block)blockWallSign);
            BLOCKS_SIGNS.add((Block)blockStandingSign);
        }
        for (String entry : ForgeConfigHandler.server.customBoats) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                Item plankItem = Item.func_111206_d((String)args[1].trim());
                int plankMeta = Integer.parseInt(args[2].trim());
                Item stickItem = Item.func_111206_d((String)args[3].trim());
                int stickMeta = Integer.parseInt(args[4].trim());
                ITEMS_BOATS.add(new CustomItemBoat(name2, plankItem, plankMeta, stickItem, stickMeta));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse boat entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customHorseArmors) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                int armorStrength = Integer.parseInt(args[1].trim());
                HorseArmorType horseArmorType = EnumHelper.addHorseArmor((String)name2, (String)("bblsom:textures/entity/horse/armor/" + name2 + ".png"), (int)armorStrength);
                ITEMS_HORSEARMOR.add(new CustomItemHorseArmor(name2, horseArmorType));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse horse armor entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customHoneyBlocks) {
            name = entry.trim();
            if (name.isEmpty()) continue;
            BLOCKS_HONEY.add((Block)new CustomBlockHoney(name));
        }
        for (String entry : ForgeConfigHandler.server.customDoors) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                boolean wooden = Boolean.parseBoolean(args[1].trim());
                BLOCKS_DOORS.add((Block)new CustomBlockDoor(name2, wooden));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse door entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customTrapDoors) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                boolean wooden = Boolean.parseBoolean(args[1].trim());
                BLOCKS_TRAPDOORS.add((Block)new CustomBlockTrapDoor(name2, wooden));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse trapdoor entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customPressurePlates) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                boolean wooden = Boolean.parseBoolean(args[1].trim());
                boolean playerOnly = false;
                if (args.length > 2) {
                    playerOnly = Boolean.parseBoolean(args[2].trim());
                }
                BLOCKS_PRESSUREPLATES.add((Block)new CustomBlockPressurePlate(name2, wooden, playerOnly));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse pressure plate entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customWeightedPressurePlates) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                int weight = Integer.parseInt(args[1].trim());
                boolean playerOnly = false;
                if (args.length > 2) {
                    playerOnly = Boolean.parseBoolean(args[2].trim());
                }
                BLOCKS_PRESSUREPLATESWEIGHTED.add((Block)new CustomBlockPressurePlateWeighted(name2, weight, playerOnly));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse weighted pressure plate entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customDirt) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                boolean supportsGeneralPlants = true;
                if (args.length > 1) {
                    supportsGeneralPlants = Boolean.parseBoolean(args[1].trim());
                }
                boolean supportsSandyPlants = false;
                if (args.length > 2) {
                    supportsSandyPlants = Boolean.parseBoolean(args[2].trim());
                }
                boolean supportsMushrooms = false;
                if (args.length > 3) {
                    supportsMushrooms = Boolean.parseBoolean(args[3].trim());
                }
                float hardness = 0.5f;
                if (args.length > 4) {
                    hardness = Float.parseFloat(args[4].trim());
                }
                Material material2 = null;
                if (args.length > 5) {
                    material2 = ModRegistry.materialFromString(args[5].trim());
                }
                if (material2 == null) {
                    material2 = Material.field_151578_c;
                }
                SoundType soundType2 = null;
                if (args.length > 6) {
                    soundType2 = ModRegistry.soundTypeFromString(args[6].trim());
                }
                if (soundType2 == null) {
                    soundType2 = SoundType.field_185849_b;
                }
                ResourceLocation farmlandBlockLocation = null;
                if (args.length > 7) {
                    farmlandBlockLocation = new ResourceLocation(args[7].trim());
                }
                BLOCKS_DIRT.add(new CustomBlockDirt(name2, supportsGeneralPlants, supportsSandyPlants, supportsMushrooms, hardness, material2, soundType2, farmlandBlockLocation));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse dirt entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customFallingDirt) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                int dustColor = Integer.parseInt(args[1].trim());
                boolean supportsGeneralPlants = true;
                if (args.length > 2) {
                    supportsGeneralPlants = Boolean.parseBoolean(args[2].trim());
                }
                boolean supportsSandyPlants = false;
                if (args.length > 3) {
                    supportsSandyPlants = Boolean.parseBoolean(args[3].trim());
                }
                boolean supportsMushrooms = false;
                if (args.length > 4) {
                    supportsMushrooms = Boolean.parseBoolean(args[4].trim());
                }
                float hardness = 0.5f;
                if (args.length > 5) {
                    hardness = Float.parseFloat(args[5].trim());
                }
                material = null;
                if (args.length > 6) {
                    material = ModRegistry.materialFromString(args[6].trim());
                }
                if (material == null) {
                    material = Material.field_151595_p;
                }
                soundType = null;
                if (args.length > 7) {
                    soundType = ModRegistry.soundTypeFromString(args[7].trim());
                }
                if (soundType == null) {
                    soundType = SoundType.field_185849_b;
                }
                BLOCKS_FALLINGDIRT.add((Block)new CustomBlockFallingDirt(name2, dustColor, supportsGeneralPlants, supportsSandyPlants, supportsMushrooms, hardness, material, soundType));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse falling dirt entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customGrass) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                ResourceLocation baseBlockLocation = new ResourceLocation(args[1].trim());
                boolean supportsGeneralPlants = true;
                if (args.length > 2) {
                    supportsGeneralPlants = Boolean.parseBoolean(args[2].trim());
                }
                boolean supportsSandyPlants = false;
                if (args.length > 3) {
                    supportsSandyPlants = Boolean.parseBoolean(args[3].trim());
                }
                boolean supportsMushrooms = false;
                if (args.length > 4) {
                    supportsMushrooms = Boolean.parseBoolean(args[4].trim());
                }
                float hardness = 0.6f;
                if (args.length > 5) {
                    hardness = Float.parseFloat(args[5].trim());
                }
                material = null;
                if (args.length > 6) {
                    material = ModRegistry.materialFromString(args[6].trim());
                }
                if (material == null) {
                    material = Material.field_151577_b;
                }
                soundType = null;
                if (args.length > 7) {
                    soundType = ModRegistry.soundTypeFromString(args[7].trim());
                }
                if (soundType == null) {
                    soundType = SoundType.field_185850_c;
                }
                ResourceLocation farmlandBlockLocation = null;
                if (args.length > 8) {
                    farmlandBlockLocation = new ResourceLocation(args[8].trim());
                }
                BLOCKS_GRASS.add(new CustomBlockGrass(name2, supportsGeneralPlants, supportsSandyPlants, supportsMushrooms, hardness, material, soundType, baseBlockLocation, farmlandBlockLocation));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse grass entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customFarmland) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                ResourceLocation baseBlockLocation = new ResourceLocation(args[1].trim());
                float growthMult = 1.0f;
                if (args.length > 2) {
                    growthMult = Float.parseFloat(args[2].trim());
                }
                boolean alwaysFertile = false;
                if (args.length > 3) {
                    alwaysFertile = Boolean.parseBoolean(args[3].trim());
                }
                BLOCKS_FARMLAND.add((Block)new CustomBlockFarmland(name2, baseBlockLocation, growthMult, alwaysFertile));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse farmland entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customLeaves) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                Item saplingItem = Item.func_111206_d((String)args[1].trim());
                boolean decayable = true;
                if (args.length > 2) {
                    decayable = Boolean.parseBoolean(args[2].trim());
                }
                Item fruitItem = null;
                if (args.length > 3) {
                    fruitItem = Item.func_111206_d((String)args[3].trim());
                }
                float fruitChanceGeneral = 0.05f;
                if (args.length > 4) {
                    fruitChanceGeneral = Float.parseFloat(args[4].trim());
                }
                float fruitChanceFruiting = 1.0f;
                if (args.length > 5) {
                    fruitChanceFruiting = Float.parseFloat(args[5].trim());
                }
                boolean canGrow = true;
                if (args.length > 6) {
                    canGrow = Boolean.parseBoolean(args[6].trim());
                }
                float growthChance = 0.05f;
                if (args.length > 7) {
                    growthChance = Float.parseFloat(args[7].trim());
                }
                BLOCKS_LEAVES.add((Block)new CustomBlockLeaves(name2, saplingItem, decayable, fruitItem, fruitChanceGeneral, fruitChanceFruiting, canGrow, growthChance));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse leaves entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customMushroom) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                boolean canGrowLarge = true;
                if (args.length > 1) {
                    canGrowLarge = Boolean.parseBoolean(args[1].trim());
                }
                boolean rounded = false;
                if (args.length > 2) {
                    rounded = Boolean.parseBoolean(args[2].trim());
                }
                BLOCKS_MUSHROOM.add((Block)new CustomBlockMushroom(name2, canGrowLarge, rounded));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse mushroom entry: " + entry);
            }
        }
        for (String entry : ForgeConfigHandler.server.customLitter) {
            if (entry.isEmpty()) continue;
            args = entry.split(",");
            try {
                name2 = args[0].trim();
                boolean checkCanStay = Boolean.parseBoolean(args[1].trim());
                double dropChance = Double.parseDouble(args[2].trim());
                BLOCKS_LITTER.add((Block)new CustomBlockLitter(name2, checkCanStay, dropChance));
            }
            catch (Exception ex) {
                BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse litter entry: " + entry);
            }
        }
    }

    @SubscribeEvent
    public static void registerItemEvent(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS_BUTTONS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_LEVERS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_SIGNS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_BOATS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_HORSEARMOR) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_HONEY) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_DOORS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_TRAPDOORS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_PRESSUREPLATES) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_PRESSUREPLATESWEIGHTED) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_DIRT) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_FALLINGDIRT) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_GRASS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_FARMLAND) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_LEAVES) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_MUSHROOM) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_HUGEMUSHROOM) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS_LITTER) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerBlockEvent(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS_BUTTONS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_LEVERS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_SIGNS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_HONEY) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_DOORS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_TRAPDOORS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_PRESSUREPLATES) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_PRESSUREPLATESWEIGHTED) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_DIRT) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_FALLINGDIRT) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_GRASS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_FARMLAND) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_LEAVES) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_MUSHROOM) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_HUGEMUSHROOM) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : BLOCKS_LITTER) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerEntityEvent(RegistryEvent.Register<EntityEntry> event) {
        int id = 1;
        for (CustomItemBoat item : ITEMS_BOATS) {
            ModRegistry.registerEntity(EntityEntryBuilder.create(), event, CustomEntityBoat.class, item.getCustomBoatType().getName(), id, 64);
            ++id;
        }
    }

    @SubscribeEvent
    public static void registerSoundEvent(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)BLOCK_HONEY_SLIDE);
        event.getRegistry().register((IForgeRegistryEntry)BLOCK_HONEY_BREAK);
        event.getRegistry().register((IForgeRegistryEntry)BLOCK_HONEY_STEP);
        event.getRegistry().register((IForgeRegistryEntry)BLOCK_HONEY_PLACE);
        event.getRegistry().register((IForgeRegistryEntry)BLOCK_HONEY_HIT);
        event.getRegistry().register((IForgeRegistryEntry)BLOCK_HONEY_FALL);
    }

    private static void registerEntity(EntityEntryBuilder builder, RegistryEvent.Register<EntityEntry> event, Class<? extends Entity> entityClass, String name, int id, int range) {
        builder.entity(entityClass);
        builder.id(new ResourceLocation("bblsom", name), id += 1069);
        builder.name(name);
        builder.tracker(range, 1, true);
        event.getRegistry().register((IForgeRegistryEntry)builder.build());
    }

    @Nullable
    private static Material materialFromString(String name) {
        switch (name) {
            case "AIR": {
                return Material.field_151579_a;
            }
            case "GRASS": {
                return Material.field_151577_b;
            }
            case "GROUND": {
                return Material.field_151578_c;
            }
            case "WOOD": {
                return Material.field_151575_d;
            }
            case "ROCK": {
                return Material.field_151576_e;
            }
            case "IRON": {
                return Material.field_151573_f;
            }
            case "ANVIL": {
                return Material.field_151574_g;
            }
            case "WATER": {
                return Material.field_151586_h;
            }
            case "LAVA": {
                return Material.field_151587_i;
            }
            case "LEAVES": {
                return Material.field_151584_j;
            }
            case "PLANTS": {
                return Material.field_151585_k;
            }
            case "VINE": {
                return Material.field_151582_l;
            }
            case "SPONGE": {
                return Material.field_151583_m;
            }
            case "CLOTH": {
                return Material.field_151580_n;
            }
            case "FIRE": {
                return Material.field_151581_o;
            }
            case "SAND": {
                return Material.field_151595_p;
            }
            case "CIRCUITS": {
                return Material.field_151594_q;
            }
            case "CARPET": {
                return Material.field_151593_r;
            }
            case "GLASS": {
                return Material.field_151592_s;
            }
            case "REDSTONE_LIGHT": {
                return Material.field_151591_t;
            }
            case "TNT": {
                return Material.field_151590_u;
            }
            case "CORAL": {
                return Material.field_151589_v;
            }
            case "ICE": {
                return Material.field_151588_w;
            }
            case "PACKED_ICE": {
                return Material.field_151598_x;
            }
            case "SNOW": {
                return Material.field_151597_y;
            }
            case "CRAFTED_SNOW": {
                return Material.field_151596_z;
            }
            case "CACTUS": {
                return Material.field_151570_A;
            }
            case "CLAY": {
                return Material.field_151571_B;
            }
            case "GOURD": {
                return Material.field_151572_C;
            }
            case "DRAGON_EGG": {
                return Material.field_151566_D;
            }
            case "PORTAL": {
                return Material.field_151567_E;
            }
            case "CAKE": {
                return Material.field_151568_F;
            }
            case "WEB": {
                return Material.field_151569_G;
            }
            case "PISTON": {
                return Material.field_76233_E;
            }
            case "BARRIER": {
                return Material.field_175972_I;
            }
            case "STRUCTURE_VOID": {
                return Material.field_189963_J;
            }
        }
        BBLSOhMy.LOGGER.log(Level.WARN, "Invalid material name: " + name);
        return null;
    }

    @Nullable
    private static SoundType soundTypeFromString(String name) {
        switch (name) {
            case "WOOD": {
                return SoundType.field_185848_a;
            }
            case "GROUND": {
                return SoundType.field_185849_b;
            }
            case "PLANT": {
                return SoundType.field_185850_c;
            }
            case "STONE": {
                return SoundType.field_185851_d;
            }
            case "METAL": {
                return SoundType.field_185852_e;
            }
            case "GLASS": {
                return SoundType.field_185853_f;
            }
            case "CLOTH": {
                return SoundType.field_185854_g;
            }
            case "SAND": {
                return SoundType.field_185855_h;
            }
            case "SNOW": {
                return SoundType.field_185856_i;
            }
            case "LADDER": {
                return SoundType.field_185857_j;
            }
            case "ANVIL": {
                return SoundType.field_185858_k;
            }
            case "SLIME": {
                return SoundType.field_185859_l;
            }
        }
        BBLSOhMy.LOGGER.log(Level.WARN, "Invalid sound type name: " + name);
        return null;
    }
}

