/*
 * Decompiled with CFR 0.152.
 */
package bblsom.handlers;

import bblsom.BBLSOhMy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

@Config(modid="bblsom")
public class ForgeConfigHandler {
    @Config.Comment(value={"Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server = new ServerConfig();
    private static Map<BlockEntry, Map<BlockEntry, BlockEntry>> grassConversions = null;

    @Nullable
    public static Map<BlockEntry, BlockEntry> getGrassConversions(IBlockState stateIn) {
        if (grassConversions == null) {
            grassConversions = new HashMap<BlockEntry, Map<BlockEntry, BlockEntry>>();
            for (String entry : ForgeConfigHandler.server.additionalGrassSpreading) {
                if (entry.trim().isEmpty()) continue;
                String[] arr = entry.split(",");
                try {
                    BlockEntry sourceBlockEntry = BlockEntry.getEntryFromIdentifier(arr[0].trim());
                    if (sourceBlockEntry == null) {
                        throw new Exception();
                    }
                    HashMap<BlockEntry, BlockEntry> conversionMap = new HashMap<BlockEntry, BlockEntry>();
                    for (int i = 1; i < arr.length; ++i) {
                        String pairEntry = arr[i].trim();
                        if (pairEntry.isEmpty()) continue;
                        String[] pair = pairEntry.split(";");
                        try {
                            BlockEntry convertBlockEntry = BlockEntry.getEntryFromIdentifier(pair[0].trim());
                            BlockEntry resultBlockEntry = BlockEntry.getEntryFromIdentifier(pair[1].trim());
                            if (convertBlockEntry == null || resultBlockEntry == null) {
                                throw new Exception();
                            }
                            conversionMap.put(convertBlockEntry, resultBlockEntry);
                            continue;
                        }
                        catch (Exception ex) {
                            BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse grass conversion entry pair: " + pairEntry);
                        }
                    }
                    grassConversions.put(sourceBlockEntry, conversionMap);
                }
                catch (Exception ex) {
                    BBLSOhMy.LOGGER.log(Level.ERROR, "Failed to parse grass conversion entry: " + entry);
                }
            }
        }
        for (Map.Entry entry : grassConversions.entrySet()) {
            if (!((BlockEntry)entry.getKey()).entryMatches(stateIn)) continue;
            return (Map)entry.getValue();
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="bblsom")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("bblsom")) {
                ConfigManager.sync((String)"bblsom", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class BlockEntry {
        private final Block block;
        private final int metadata;

        private BlockEntry(Block block, int metadata) {
            this.block = block;
            this.metadata = metadata;
        }

        public IBlockState getState() {
            if (this.metadata < 0) {
                return this.block.func_176223_P();
            }
            return this.block.func_176203_a(this.metadata);
        }

        public boolean entryMatches(IBlockState state) {
            if (state == null) {
                return false;
            }
            if (state.func_177230_c() == this.block) {
                return this.metadata == -1 || this.metadata == state.func_177230_c().func_176201_c(state);
            }
            return false;
        }

        @Nullable
        public static BlockEntry getEntryFromIdentifier(String entry) {
            ResourceLocation loc;
            String[] arr = entry.split(":");
            if (arr.length == 0) {
                return null;
            }
            int meta = -1;
            boolean hasMeta = false;
            try {
                meta = Integer.parseInt(arr[arr.length - 1].trim());
                hasMeta = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (arr.length == 1) {
                if (hasMeta) {
                    return null;
                }
                loc = new ResourceLocation(arr[0].trim());
            } else if (arr.length == 2) {
                loc = hasMeta ? new ResourceLocation(arr[0].trim()) : new ResourceLocation(arr[0].trim(), arr[1].trim());
            } else if (arr.length == 3) {
                if (!hasMeta) {
                    return null;
                }
                loc = new ResourceLocation(arr[0].trim(), arr[1].trim());
            } else {
                return null;
            }
            Block entryBlock = (Block)ForgeRegistries.BLOCKS.getValue(loc);
            if (entryBlock == null) {
                return null;
            }
            return new BlockEntry(entryBlock, meta);
        }
    }

    public static class ServerConfig {
        @Config.Comment(value={"Custom Buttons to be registered\nFormat: String name, Boolean wooden, int tickrate\nString name: the name of the item/block to be registered\nBoolean wooden: whether the button should be treated as wooden or not (Affects sound and tickrate)\nint tickrate: tickrate override for the button, if left as 0 uses the vanilla handling based on wooden or not"})
        @Config.Name(value="Custom Button Entries")
        @Config.RequiresMcRestart
        public String[] customButtons = new String[]{""};
        @Config.Comment(value={"Custom Levers to be registered\nFormat: String name\nString name: the name of the item/block to be registered"})
        @Config.Name(value="Custom Lever Entries")
        @Config.RequiresMcRestart
        public String[] customLevers = new String[]{""};
        @Config.Comment(value={"Custom Signs to be registered\nFormat: String name\nString name: the name of the item/block to be registered"})
        @Config.Name(value="Custom Sign Entries")
        @Config.RequiresMcRestart
        public String[] customSigns = new String[]{""};
        @Config.Comment(value={"Custom Boats to be registered\nFormat: String name, ItemID plankItem, int plankMeta, ItemID stickItem, int stickMeta\nString name: the name of the item/boat to be registered\nItemID plankItem: The item id of the plank-like item to be dropped when the boat is broken dangerously\nint plankMeta: The metadata of the plank-like item to be dropped when the boat is broken dangerously\nItemID stickItem: The item id of the stick-like item to be dropped when the boat is broken dangerously\nint stickMeta: The metadata of the stick-like item to be dropped when the boat is broken dangerously"})
        @Config.Name(value="Custom Boat Entries")
        @Config.RequiresMcRestart
        public String[] customBoats = new String[]{""};
        @Config.Comment(value={"Custom Horse Armors to be registered\nFormat: String name, int armorStrength\nString name: the name of the armor to be registered\nint armorStrength: the strength of the armor to be registered"})
        @Config.Name(value="Custom Horse Armor Entries")
        @Config.RequiresMcRestart
        public String[] customHorseArmors = new String[]{""};
        @Config.Comment(value={"Custom Honey Blocks to be registered\nFormat: String name\nString name: the name of the item/block to be registered"})
        @Config.Name(value="Custom Honey Block Entries")
        @Config.RequiresMcRestart
        public String[] customHoneyBlocks = new String[]{"block_honey"};
        @Config.Comment(value={"Custom Doors to be registered\nFormat: String name, Boolean wooden\nString name: the name of the item/block to be registered\nBoolean wooden: whether the door should be treated as wooden or not (Affects sound and redstone interaction)"})
        @Config.Name(value="Custom Door Entries")
        @Config.RequiresMcRestart
        public String[] customDoors = new String[]{""};
        @Config.Comment(value={"Custom Trap Doors to be registered\nFormat: String name, Boolean wooden\nString name: the name of the item/block to be registered\nBoolean wooden: whether the trap door should be treated as wooden or not (Affects sound and redstone interaction)"})
        @Config.Name(value="Custom Trap Door Entries")
        @Config.RequiresMcRestart
        public String[] customTrapDoors = new String[]{""};
        @Config.Comment(value={"Custom Pressure Plates to be registered\nFormat: String name, Boolean wooden\nString name: the name of the item/block to be registered\nBoolean wooden: whether the pressure plate should be treated as wooden or not (Affects sound and redstone interaction)\n(Optional, default false) Boolean playerOnly: whether only players should be able to trigger the pressure plate"})
        @Config.Name(value="Custom Pressure Plate Entries")
        @Config.RequiresMcRestart
        public String[] customPressurePlates = new String[]{""};
        @Config.Comment(value={"Custom Weighted Pressure Plates to be registered\nFormat: String name, int maxWeight\nString name: the name of the item/block to be registered\nint maxWeight: max weight to trigger the pressure plate\n(Optional, default false) Boolean playerOnly: whether only players should be able to trigger the pressure plate"})
        @Config.Name(value="Custom Weighted Pressure Plate Entries")
        @Config.RequiresMcRestart
        public String[] customWeightedPressurePlates = new String[]{""};
        @Config.Comment(value={"Custom Dirt to be registered\nFormat: String name, Boolean supportsGeneralPlants, Boolean supportsSandyPlants, Boolean supportsMushrooms, Float hardness, String material, String soundType, BlockID farmlandBlock\nString name: the name of the item/block to be registered\n(Optional, default true) Boolean supportsGeneralPlants: if the dirt should support general plants growing on it\n(Optional, default false) Boolean supportsSandyPlants: if the dirt should support sandy plants growing on it\n(Optional, default false) Boolean supportsMushrooms: if the dirt should support mushrooms growing on it\n(Optional, default 0.5) Float hardness: the block hardness\n(Optional, default GROUND) String material: the block Material\n(Optional, default GROUND) String soundType: the block SoundType\n(Optional, default disabled) BlockID farmlandBlock: the farmland block that the dirt should turn into upon hoe-ing"})
        @Config.Name(value="Custom Dirt Entries")
        @Config.RequiresMcRestart
        public String[] customDirt = new String[]{""};
        @Config.Comment(value={"Custom Falling Dirt to be registered\nFormat: String name, int dustColor, Boolean supportsGeneralPlants, Boolean supportsSandyPlants, Boolean supportsMushrooms, Float hardness, String material, String soundType\nString name: the name of the item/block to be registered\nint dustColor: decimal color value to be used for block falling particles\n(Optional, default true) Boolean supportsGeneralPlants: if the dirt should support general plants growing on it\n(Optional, default false) Boolean supportsSandyPlants: if the dirt should support sandy plants growing on it\n(Optional, default false) Boolean supportsMushrooms: if the dirt should support mushrooms growing on it\n(Optional, default 0.5) Float hardness: the block hardness\n(Optional, default SAND) String material: the block Material\n(Optional, default GROUND) String soundType: the block SoundType"})
        @Config.Name(value="Custom Falling Dirt Entries")
        @Config.RequiresMcRestart
        public String[] customFallingDirt = new String[]{""};
        @Config.Comment(value={"Custom Grass to be registered\nFormat: String name, BlockID baseBlock, Boolean supportsGeneralPlants, Boolean supportsSandyPlants, Boolean supportsMushrooms, Float hardness, String material, String soundType, BlockID farmlandBlock\nString name: the name of the item/block to be registered\nBlockID baseBlock: the block that the grass converts to more grass, and reverts to\n(Optional, default true) Boolean supportsGeneralPlants: if the dirt should support general plants growing on it\n(Optional, default false) Boolean supportsSandyPlants: if the dirt should support sandy plants growing on it\n(Optional, default false) Boolean supportsMushrooms: if the dirt should support mushrooms growing on it\n(Optional, default 0.6) Float hardness: the block hardness\n(Optional, default GRASS) String material: the block Material\n(Optional, default PLANT) String soundType: the block SoundType\n(Optional, default disabled) BlockID farmlandBlock: the farmland block that the grass should turn into upon hoe-ing"})
        @Config.Name(value="Custom Grass Entries")
        @Config.RequiresMcRestart
        public String[] customGrass = new String[]{""};
        @Config.Comment(value={"Custom Farmland to be registered\nFormat: String name, BlockID baseBlock, Float growthMult, Boolean alwaysFertile\nString name: the name of the item/block to be registered\nBlockID baseBlock: the block that the farmland reverts to\n(Optional, default 1.0F) Float growthMult: the multiplier for speed of crops growing on the farmland\n(Optional, default false) Boolean alwaysFertile: if the farmland should always be moisturized and fertile"})
        @Config.Name(value="Custom Farmland Entries")
        @Config.RequiresMcRestart
        public String[] customFarmland = new String[]{""};
        @Config.Comment(value={"Custom Leaves to be registered\nFormat: String name, ItemID saplingItem, Boolean decayable, ItemID fruitItem, float fruitChanceGeneral, float fruitChanceFruiting, boolean canGrow, float growthChance\nString name: the name of the item/block to be registered\nItemID saplingItem: the sapling rarity item randomly dropped when leaves are broken\n(Optional, default true) Boolean decayable: if the leaves should be allows to decay like vanilla\n(Optional, default ignored) ItemID fruitItem: the fruit item randomly dropped when leaves are broken\n(Optional, default 0.05F) Float fruitChanceGeneral: the chance when any type of leaves are broken to drop fruit\n(Optional, default 1.0F) Float fruitChanceFruiting: the chance when fruiting leaves are broken to drop fruit\n(Optional, default true) Boolean canGrow: if the leaves should be able to grow from default to flowering to fruiting when random ticked\n(Optional, default 0.05F) Float growthChance: the chance when random ticked to grow the leaves"})
        @Config.Name(value="Custom Leaves Entries")
        @Config.RequiresMcRestart
        public String[] customLeaves = new String[]{""};
        @Config.Comment(value={"Custom Mushroom to be registered\nFormat: String name, Boolean canGrowLarge, boolean rounded\nString name: the name of the item/block to be registered\n(Optional, default true) Boolean canGrowLarge: if the mushroom should be able to be turned into a large mushroom such as with bonemeal\n(Optional, default false) Boolean rounded: if the large mushroom should be rounded like red mushrooms, or flat like brown mushrooms"})
        @Config.Name(value="Custom Mushroom Entries")
        @Config.RequiresMcRestart
        public String[] customMushroom = new String[]{""};
        @Config.Comment(value={"Custom Litter to be registered\nFormat: String name, Boolean checkCanStay, double dropChance\nString name: the name of the item/block to be registered\nBoolean checkCanStay: if the litter should check if the soil can sustain it like flowers\nDouble dropChance: item drop chance per filled slice of litter"})
        @Config.Name(value="Custom Litter Entries")
        @Config.RequiresMcRestart
        public String[] customLitter = new String[]{""};
        @Config.Comment(value={"Allows for additional customization of what blocks grass-like blocks can target and what blocks they convert into\nFormat: BlockID sourceBlock, BlockID convertBlock ; BlockID resultBlock, BlockID convertBlock ; BlockID resultBlock, ... (Multiple pairs allowed)\n(Optional: add :metadata after a BlockID to specify metadata)\nBlockID sourceBlock: the grass-like block that starts the conversion of other blocks\nBlockID convertBlock: a block that the sourceBlock can target for conversion, non-repeatable per sourceBlock\nBlockID resultBlock: the block that the convertBlock turns into after being converted by the sourceBlock, repeatable per sourceBlock"})
        @Config.Name(value="Additional Grass Spreading Settings")
        @Config.RequiresMcRestart
        public String[] additionalGrassSpreading = new String[]{""};
    }
}

