/*
 * Decompiled with CFR 0.152.
 */
package bblsom.handlers;

import bblsom.blocks.CustomBlockLeaves;
import bblsom.handlers.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="bblsom", value={Side.CLIENT})
public class ClientModRegistry {
    @SubscribeEvent
    public static void modelRegisterEvent(ModelRegistryEvent event) {
        ClientModRegistry.registerModels(ModRegistry.ITEMS_BUTTONS.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_LEVERS.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_SIGNS.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_HONEY.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_BOATS.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_HORSEARMOR.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_DOORS.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_TRAPDOORS.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_PRESSUREPLATES.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_PRESSUREPLATESWEIGHTED.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_DIRT.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_FALLINGDIRT.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_GRASS.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_FARMLAND.toArray(new Item[0]));
        ClientModRegistry.registerLeavesModels(ModRegistry.ITEMS_LEAVES.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_MUSHROOM.toArray(new Item[0]));
        ClientModRegistry.registerHugeMushroomModels(ModRegistry.ITEMS_HUGEMUSHROOM.toArray(new Item[0]));
        ClientModRegistry.registerModels(ModRegistry.ITEMS_LITTER.toArray(new Item[0]));
        ClientModRegistry.registerDoorMapper(ModRegistry.BLOCKS_DOORS.toArray(new Block[0]));
        ClientModRegistry.registerLeavesMapper(ModRegistry.BLOCKS_LEAVES.toArray(new Block[0]));
    }

    private static void registerModels(Item ... values) {
        for (Item entry : values) {
            ModelLoader.setCustomModelResourceLocation((Item)entry, (int)0, (ModelResourceLocation)new ModelResourceLocation(entry.getRegistryName(), "inventory"));
        }
    }

    private static void registerLeavesModels(Item ... values) {
        for (Item entry : values) {
            for (CustomBlockLeaves.AgePhase phase : CustomBlockLeaves.AgePhase.values()) {
                ModelLoader.setCustomModelResourceLocation((Item)entry, (int)phase.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(entry.getRegistryName().func_110624_b() + ":" + phase.func_176610_l() + "_" + entry.getRegistryName().func_110623_a(), "inventory"));
            }
        }
    }

    private static void registerHugeMushroomModels(Item ... values) {
        for (Item entry : values) {
            ModelLoader.setCustomModelResourceLocation((Item)entry, (int)BlockHugeMushroom.EnumType.ALL_INSIDE.func_176896_a(), (ModelResourceLocation)new ModelResourceLocation(entry.getRegistryName(), "inventory"));
        }
    }

    private static void registerDoorMapper(Block ... values) {
        for (Block entry : values) {
            ModelLoader.setCustomStateMapper((Block)entry, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        }
    }

    private static void registerLeavesMapper(Block ... values) {
        for (Block entry : values) {
            ModelLoader.setCustomStateMapper((Block)entry, (IStateMapper)new StateMap.Builder().func_178440_a(CustomBlockLeaves.AGE).func_178439_a("_" + entry.getRegistryName().func_110623_a()).func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        }
    }

    @SubscribeEvent
    public static void blockColorHandlerEvent(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0), ModRegistry.BLOCKS_GRASS.toArray(new Block[0]));
        colors.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c(), ModRegistry.BLOCKS_LEAVES.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void itemColorHandlerEvent(ColorHandlerEvent.Item event) {
        BlockColors colors = event.getBlockColors();
        event.getItemColors().func_186731_a((stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return colors.func_186724_a(iblockstate, null, null, tintIndex);
        }, ModRegistry.BLOCKS_GRASS.toArray(new Block[0]));
        event.getItemColors().func_186731_a((stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return colors.func_186724_a(iblockstate, null, null, tintIndex);
        }, ModRegistry.BLOCKS_LEAVES.toArray(new Block[0]));
    }
}

