/*
 * Decompiled with CFR 0.152.
 */
package bblsom.entity;

import bblsom.BBLSOhMy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class CustomEntityBoat
extends EntityBoat {
    private static final DataParameter<String> CUSTOM_BOAT_TYPE = EntityDataManager.func_187226_a(CustomEntityBoat.class, (DataSerializer)DataSerializers.field_187194_d);

    public CustomEntityBoat(World worldIn) {
        super(worldIn);
    }

    public CustomEntityBoat(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public ItemStack getDroppedPlanks() {
        return this.getCustomBoatType().getDroppedPlanks();
    }

    public ItemStack getDroppedSticks() {
        return this.getCustomBoatType().getDroppedSticks();
    }

    public void setCustomBoatType(CustomBoatType customBoatType) {
        this.field_70180_af.func_187227_b(CUSTOM_BOAT_TYPE, (Object)customBoatType.getName());
    }

    public CustomBoatType getCustomBoatType() {
        return CustomBoatType.getCustomTypeFromString((String)this.field_70180_af.func_187225_a(CUSTOM_BOAT_TYPE));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CUSTOM_BOAT_TYPE, (Object)"null");
    }

    public Item func_184455_j() {
        return this.getCustomBoatType().getItemBoat();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("CustomType", this.getCustomBoatType().getName());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("CustomType", 8)) {
            this.setCustomBoatType(CustomBoatType.getCustomTypeFromString(compound.func_74779_i("CustomType")));
        }
    }

    public static class CustomBoatType {
        public static final List<CustomBoatType> CUSTOM_BOAT_TYPES = new ArrayList<CustomBoatType>();
        public static final CustomBoatType NULL_TYPE;
        private final String name;
        private final ResourceLocation texture;
        private Item boatItem = null;
        private Item plankItem = null;
        private int plankMeta = 0;
        private Item stickItem = null;
        private int stickMeta = 0;

        public CustomBoatType(String name) {
            this.name = name;
            this.texture = new ResourceLocation("bblsom:textures/entity/boat/" + name + ".png");
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public Item getItemBoat() {
            return this.boatItem;
        }

        public ItemStack getDroppedPlanks() {
            return new ItemStack(this.plankItem, 1, this.plankMeta);
        }

        public ItemStack getDroppedSticks() {
            return new ItemStack(this.stickItem, 1, this.stickMeta);
        }

        public void setItemBoat(Item boatItem) {
            this.boatItem = boatItem;
        }

        public void setDroppedPlanks(Item plankItem, int plankMeta) {
            this.plankItem = plankItem;
            this.plankMeta = plankMeta;
        }

        public void setDroppedSticks(Item stickItem, int stickMeta) {
            this.stickItem = stickItem;
            this.stickMeta = stickMeta;
        }

        public static CustomBoatType getCustomTypeFromString(String name) {
            for (CustomBoatType customBoatType : CUSTOM_BOAT_TYPES) {
                if (!customBoatType.getName().equals(name)) continue;
                return customBoatType;
            }
            BBLSOhMy.LOGGER.log(Level.ERROR, "Attempted to get custom boat by name: " + name + " but it is not registered");
            return NULL_TYPE;
        }

        static {
            CustomBoatType nullType = new CustomBoatType("null");
            nullType.setItemBoat(Items.field_151124_az);
            nullType.setDroppedPlanks(Item.func_150898_a((Block)Blocks.field_150344_f), 0);
            nullType.setDroppedSticks(Items.field_151055_y, 0);
            NULL_TYPE = nullType;
        }
    }
}

