/*
 * Decompiled with CFR 0.152.
 */
package bblsom.blocks;

import bblsom.handlers.ModRegistry;
import bblsom.item.CustomItemLeaves;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CustomBlockLeaves
extends BlockLeaves {
    public static final PropertyEnum<AgePhase> AGE = PropertyEnum.func_177709_a((String)"age", AgePhase.class);
    private final Item saplingItem;
    private final Item fruitItem;
    private final float fruitChanceGeneral;
    private final float fruitChanceFruiting;
    private final boolean canGrow;
    private final float growthChance;

    public CustomBlockLeaves(String name, Item saplingItem, boolean decayable, Item fruitItem, float fruitChanceGeneral, float fruitChanceFruiting, boolean canGrow, float growthChance) {
        this.setRegistryName("bblsom:" + name);
        this.func_149663_c("bblsom." + name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AGE, (Comparable)((Object)AgePhase.NORMAL)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(decayable)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(decayable)));
        this.saplingItem = saplingItem;
        this.fruitItem = fruitItem;
        this.fruitChanceGeneral = fruitChanceGeneral;
        this.fruitChanceFruiting = fruitChanceFruiting;
        this.canGrow = canGrow;
        this.growthChance = growthChance;
        ModRegistry.ITEMS_LEAVES.add(((Item)new CustomItemLeaves(this).setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a()));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.field_72995_K && this.canGrow) {
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (rand.nextFloat() < this.growthChance) {
                IBlockState worldState = worldIn.func_180495_p(pos);
                if (worldState.func_177230_c() != this) {
                    return;
                }
                int age = ((AgePhase)((Object)worldState.func_177229_b(AGE))).getMetadata();
                if (age < 2) {
                    worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a(AGE, (Comparable)((Object)AgePhase.fromMetadata(age + 1))).func_177226_a((IProperty)field_176236_b, worldState.func_177229_b((IProperty)field_176236_b)).func_177226_a((IProperty)field_176237_a, worldState.func_177229_b((IProperty)field_176237_a)), 2);
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.saplingItem;
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (this.fruitItem != null) {
            if (state.func_177229_b(AGE) == AgePhase.FRUITING) {
                if (worldIn.field_73012_v.nextFloat() < this.fruitChanceFruiting) {
                    CustomBlockLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(this.fruitItem));
                }
            } else if (worldIn.field_73012_v.nextFloat() < this.fruitChanceGeneral) {
                CustomBlockLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(this.fruitItem));
            }
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state) & 3);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((AgePhase)((Object)state.func_177229_b(AGE))).getMetadata());
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public AgePhase getAgePhase(int meta) {
        return AgePhase.fromMetadata((meta & 3) % 4);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, field_176236_b, field_176237_a});
    }

    public int func_180651_a(IBlockState state) {
        return ((AgePhase)((Object)state.func_177229_b(AGE))).getMetadata();
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            CustomBlockLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this), 1, ((AgePhase)((Object)state.func_177229_b(AGE))).getMetadata()));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, ((AgePhase)((Object)world.func_180495_p(pos).func_177229_b(AGE))).getMetadata()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AGE, (Comparable)((Object)this.getAgePhase(meta))).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((AgePhase)((Object)state.func_177229_b(AGE))).getMetadata();
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public static enum AgePhase implements IStringSerializable
    {
        NORMAL(0, "normal"),
        FLOWERING(1, "flowering"),
        FRUITING(2, "fruiting");

        private static final AgePhase[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;

        private AgePhase(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public static AgePhase fromMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            METADATA_LOOKUP = new AgePhase[AgePhase.values().length];
            AgePhase[] agePhaseArray = AgePhase.values();
            int n = agePhaseArray.length;
            for (int i = 0; i < n; ++i) {
                AgePhase phase;
                AgePhase.METADATA_LOOKUP[phase.getMetadata()] = phase = agePhaseArray[i];
            }
        }
    }
}

