/*
 * Decompiled with CFR 0.152.
 */
package bblsom.blocks;

import bblsom.handlers.ModRegistry;
import bblsom.mixin.vanilla.IEntityLivingBaseMixin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomBlockHoney
extends BlockBreakable {
    private static final AxisAlignedBB HONEY_COLLISION_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    protected static final AxisAlignedBB HONEY_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public CustomBlockHoney(String name) {
        super(Material.field_151571_B, false, MapColor.field_151647_F);
        this.setRegistryName("bblsom:" + name);
        this.func_149663_c("bblsom." + name);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149672_a(ModRegistry.BLOCK_HONEY_TYPE);
        ModRegistry.ITEMS_HONEY.add(((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a()));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return HONEY_COLLISION_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return HONEY_AABB.func_186670_a(pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.field_70170_p.func_184133_a(null, pos, ModRegistry.BLOCK_HONEY_SLIDE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (entityIn.func_70093_af()) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        } else {
            entityIn.func_180430_e(fallDistance, 0.2f);
            entityIn.field_70170_p.func_184133_a(null, pos, this.field_149762_H.func_185842_g(), SoundCategory.BLOCKS, this.field_149762_H.func_185843_a() * 0.5f, this.field_149762_H.func_185847_b() * 0.75f);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            ((IEntityLivingBaseMixin)((EntityLivingBase)entityIn)).setJumpTicks(10);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isSlidingDown(pos, entity)) {
            this.doSlideMovement(entity);
            if (entity instanceof EntityLivingBase && world.field_73012_v.nextInt(5) == 0) {
                entity.func_184185_a(ModRegistry.BLOCK_HONEY_SLIDE, 1.0f, 1.0f);
            }
        } else if (entity.field_70181_x <= 0.05) {
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
        }
        super.func_180634_a(world, pos, state, entity);
    }

    private boolean isSlidingDown(BlockPos pos, Entity entity) {
        if (entity.field_70122_E) {
            return false;
        }
        if (entity.field_70163_u > (double)pos.func_177956_o() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.field_70181_x >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)pos.func_177958_n() + 0.5 - entity.field_70165_t);
        double d1 = Math.abs((double)pos.func_177952_p() + 0.5 - entity.field_70161_v);
        double d2 = 0.4375 + (double)(entity.field_70130_N / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    private void doSlideMovement(Entity entity) {
        if (entity.field_70181_x < -0.13) {
            double d0 = -0.05 / entity.field_70181_x;
            entity.field_70159_w *= d0;
            entity.field_70181_x = -0.05;
            entity.field_70179_y *= d0;
        } else {
            entity.field_70181_x = -0.05;
        }
        entity.field_70143_R = 0.0f;
        entity.field_70122_E = true;
    }
}

