/*
 * Decompiled with CFR 0.152.
 */
package bblsom.blocks;

import bblsom.BBLSOhMy;
import bblsom.blocks.ICustomBlockFertile;
import bblsom.blocks.ICustomBlockLayered;
import bblsom.blocks.ICustomBlockTillable;
import bblsom.handlers.ForgeConfigHandler;
import bblsom.handlers.ModRegistry;
import bblsom.mixin.vanilla.IBlockBushMixin;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class CustomBlockGrass
extends Block
implements ICustomBlockFertile,
ICustomBlockLayered,
ICustomBlockTillable {
    private final ResourceLocation baseBlockLocation;
    private final ResourceLocation farmlandBlockLocation;
    private final boolean supportsGeneralPlants;
    private final boolean supportsSandyPlants;
    private final boolean supportsMushrooms;
    private Block baseBlock;
    private Block farmlandBlock;

    public CustomBlockGrass(String name, boolean supportsGeneralPlants, boolean supportsSandyPlants, boolean supportsMushrooms, float hardness, Material material, SoundType soundType, ResourceLocation baseBlockLocation, ResourceLocation farmlandBlockLocation) {
        super(material);
        this.setRegistryName("bblsom:" + name);
        this.func_149663_c("bblsom." + name);
        this.func_149711_c(hardness);
        this.func_149672_a(soundType);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockGrass.field_176498_a, (Comparable)Boolean.FALSE));
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.supportsGeneralPlants = supportsGeneralPlants;
        this.supportsSandyPlants = supportsSandyPlants;
        this.supportsMushrooms = supportsMushrooms;
        this.baseBlockLocation = baseBlockLocation;
        this.farmlandBlockLocation = farmlandBlockLocation;
        ModRegistry.ITEMS_GRASS.add(((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a()));
    }

    @Override
    public boolean getSupportsGeneralPlants() {
        return this.supportsGeneralPlants;
    }

    @Override
    public boolean getSupportsSandyPlants() {
        return this.supportsSandyPlants;
    }

    @Override
    public boolean getSupportsMushrooms() {
        return this.supportsMushrooms;
    }

    @Override
    @Nonnull
    public Block getBaseBlock() {
        if (this.baseBlock == null) {
            this.baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.baseBlockLocation);
            if (this.baseBlock == null) {
                BBLSOhMy.LOGGER.log(Level.WARN, "Failed to find base block: " + this.baseBlockLocation + " for block: " + this.getRegistryName());
                this.baseBlock = Blocks.field_150346_d;
            }
        }
        return this.baseBlock;
    }

    @Override
    @Nullable
    public Block getFarmlandBlock() {
        if (this.farmlandBlock == null && this.farmlandBlockLocation != null) {
            this.farmlandBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.farmlandBlockLocation);
            if (this.farmlandBlock == null) {
                BBLSOhMy.LOGGER.log(Level.WARN, "Failed to find farmland block: " + this.farmlandBlockLocation + " for block: " + this.getRegistryName());
                this.farmlandBlock = Blocks.field_150458_ak;
            }
        }
        return this.farmlandBlock;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return state.func_177226_a((IProperty)BlockGrass.field_176498_a, (Comparable)Boolean.valueOf(block == Blocks.field_150433_aE || block == Blocks.field_150431_aC));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.func_175697_a(pos, 3)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) < 4 && worldIn.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) {
                worldIn.func_175656_a(pos, this.getBaseBlock().func_176223_P());
            } else if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177984_a());
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    Map<ForgeConfigHandler.BlockEntry, ForgeConfigHandler.BlockEntry> conversionMap = ForgeConfigHandler.getGrassConversions(state);
                    if (conversionMap != null) {
                        boolean matched = false;
                        for (Map.Entry<ForgeConfigHandler.BlockEntry, ForgeConfigHandler.BlockEntry> entry : conversionMap.entrySet()) {
                            if (!entry.getKey().entryMatches(iblockstate1)) continue;
                            if (worldIn.func_175671_l(blockpos.func_177984_a()) >= 4 && iblockstate.getLightOpacity((IBlockAccess)worldIn, blockpos.func_177984_a()) <= 2) {
                                worldIn.func_175656_a(blockpos, entry.getValue().getState());
                            }
                            matched = true;
                            break;
                        }
                        if (matched) continue;
                    }
                    if (iblockstate1.func_177230_c() != this.getBaseBlock() || worldIn.func_175671_l(blockpos.func_177984_a()) < 4 || iblockstate.getLightOpacity((IBlockAccess)worldIn, blockpos.func_177984_a()) > 2) continue;
                    worldIn.func_175656_a(blockpos, this.func_176223_P());
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getBaseBlock().func_180660_a(this.getBaseBlock().func_176223_P(), rand, fortune);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockGrass.field_176498_a});
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this.getSupportsSandyPlants();
        }
        if (plantable instanceof BlockBush && ((IBlockBushMixin)plantable).getCanSustainBush(state)) {
            return true;
        }
        switch (plantType) {
            case Water: 
            case Nether: 
            case Crop: {
                return false;
            }
            case Plains: {
                return this.getSupportsGeneralPlants();
            }
            case Desert: {
                return this.getSupportsSandyPlants();
            }
            case Cave: {
                return state.isSideSolid(world, pos, EnumFacing.UP);
            }
            case Beach: {
                return !(!this.getSupportsGeneralPlants() && !this.getSupportsSandyPlants() || world.func_180495_p(pos.func_177974_f()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos.func_177976_e()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos.func_177978_c()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos.func_177968_d()).func_185904_a() != Material.field_151586_h);
            }
        }
        return false;
    }

    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        world.func_180501_a(pos, this.getBaseBlock().func_176223_P(), 2);
    }
}

