/*
 * Decompiled with CFR 0.152.
 */
package bblsom.blocks;

import bblsom.BBLSOhMy;
import bblsom.blocks.ICustomBlockLayered;
import bblsom.handlers.ModRegistry;
import bblsom.mixin.vanilla.IBlockBushMixin;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class CustomBlockFarmland
extends BlockFarmland
implements ICustomBlockLayered {
    private final ResourceLocation baseBlockLocation;
    private final float growthMult;
    private final boolean alwaysFertile;
    private Block baseBlock;

    public CustomBlockFarmland(String name, ResourceLocation baseBlockLocation, float growthMult, boolean alwaysFertile) {
        this.setRegistryName("bblsom:" + name);
        this.func_149663_c("bblsom." + name);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(alwaysFertile ? 7 : 0)));
        this.baseBlockLocation = baseBlockLocation;
        this.growthMult = growthMult;
        this.alwaysFertile = alwaysFertile;
        ModRegistry.ITEMS_FARMLAND.add(((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a()));
    }

    @Override
    @Nonnull
    public Block getBaseBlock() {
        if (this.baseBlock == null) {
            this.baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.baseBlockLocation);
            if (this.baseBlock == null) {
                BBLSOhMy.LOGGER.log(Level.WARN, "Failed to find base block: " + this.baseBlockLocation + " for block: " + this.getRegistryName());
                this.baseBlock = Blocks.field_150346_d;
            }
        }
        return this.baseBlock;
    }

    public float getFarmlandMult() {
        return this.growthMult;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.alwaysFertile) {
            int i = (Integer)state.func_177229_b((IProperty)field_176531_a);
            if (i < 7) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
        } else {
            int i = (Integer)state.func_177229_b((IProperty)field_176531_a);
            if (!this.func_176530_e(worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
                if (i > 0) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
                } else if (!this.func_176529_d(worldIn, pos)) {
                    this.turnInstanceToDirt(worldIn, pos);
                }
            } else if (i < 7) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (IBlockState)this.getBaseBlock().func_176223_P(), (float)fallDistance, (Entity)entityIn)) {
            this.turnInstanceToDirt(worldIn, pos);
        }
        entityIn.func_180430_e(fallDistance, 1.0f);
    }

    private void turnInstanceToDirt(World world, BlockPos worldIn) {
        world.func_175656_a(worldIn, this.getBaseBlock().func_176223_P());
        AxisAlignedBB axisalignedbb = field_194405_c.func_186670_a(worldIn);
        for (Entity entity : world.func_72839_b(null, axisalignedbb)) {
            double d0 = Math.min(axisalignedbb.field_72337_e - axisalignedbb.field_72338_b, axisalignedbb.field_72337_e - entity.func_174813_aQ().field_72338_b);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + d0 + 0.001, entity.field_70161_v);
        }
    }

    private boolean func_176529_d(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)block);
    }

    private boolean func_176530_e(World worldIn, BlockPos pos) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((World)worldIn, (BlockPos)pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            this.turnInstanceToDirt(worldIn, pos);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            this.turnInstanceToDirt(worldIn, pos);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getBaseBlock().func_180660_a(this.getBaseBlock().func_176223_P(), rand, fortune);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plantable instanceof BlockBush && ((IBlockBushMixin)plantable).getCanSustainBush(state)) {
            return true;
        }
        switch (plantType) {
            case Desert: 
            case Nether: 
            case Water: 
            case Beach: {
                return false;
            }
            case Crop: 
            case Plains: {
                return true;
            }
            case Cave: {
                return state.isSideSolid(world, pos, EnumFacing.UP);
            }
        }
        return false;
    }

    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        world.func_180501_a(pos, this.getBaseBlock().func_176223_P(), 2);
    }

    public boolean isFertile(World world, BlockPos pos) {
        if (this.alwaysFertile) {
            return true;
        }
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockFarmland.field_176531_a) > 0;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (base_state.func_185896_q() && side == EnumFacing.UP) {
            return true;
        }
        return side != EnumFacing.DOWN && side != EnumFacing.UP;
    }
}

