/*
 * Decompiled with CFR 0.152.
 */
package bblsom.blocks;

import bblsom.BBLSOhMy;
import bblsom.blocks.ICustomBlockFertile;
import bblsom.blocks.ICustomBlockTillable;
import bblsom.handlers.ModRegistry;
import bblsom.mixin.vanilla.IBlockBushMixin;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class CustomBlockDirt
extends Block
implements ICustomBlockFertile,
ICustomBlockTillable {
    private final ResourceLocation farmlandBlockLocation;
    private final boolean supportsGeneralPlants;
    private final boolean supportsSandyPlants;
    private final boolean supportsMushrooms;
    private Block farmlandBlock;

    public CustomBlockDirt(String name, boolean supportsGeneralPlants, boolean supportsSandyPlants, boolean supportsMushrooms, float hardness, Material material, SoundType soundType, ResourceLocation farmlandBlockLocation) {
        super(material);
        this.setRegistryName("bblsom:" + name);
        this.func_149663_c("bblsom." + name);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(hardness);
        this.func_149672_a(soundType);
        this.supportsGeneralPlants = supportsGeneralPlants;
        this.supportsSandyPlants = supportsSandyPlants;
        this.supportsMushrooms = supportsMushrooms;
        this.farmlandBlockLocation = farmlandBlockLocation;
        ModRegistry.ITEMS_DIRT.add(((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a()));
    }

    @Override
    public boolean getSupportsGeneralPlants() {
        return this.supportsGeneralPlants;
    }

    @Override
    public boolean getSupportsSandyPlants() {
        return this.supportsSandyPlants;
    }

    @Override
    public boolean getSupportsMushrooms() {
        return this.supportsMushrooms;
    }

    @Override
    @Nullable
    public Block getFarmlandBlock() {
        if (this.farmlandBlock == null && this.farmlandBlockLocation != null) {
            this.farmlandBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.farmlandBlockLocation);
            if (this.farmlandBlock == null) {
                BBLSOhMy.LOGGER.log(Level.WARN, "Failed to find farmland block: " + this.farmlandBlockLocation + " for block: " + this.getRegistryName());
                this.farmlandBlock = Blocks.field_150458_ak;
            }
        }
        return this.farmlandBlock;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this.getSupportsSandyPlants();
        }
        if (plantable instanceof BlockBush && ((IBlockBushMixin)plantable).getCanSustainBush(state)) {
            return true;
        }
        switch (plantType) {
            case Water: 
            case Nether: 
            case Crop: {
                return false;
            }
            case Plains: {
                return this.getSupportsGeneralPlants();
            }
            case Desert: {
                return this.getSupportsSandyPlants();
            }
            case Cave: {
                return state.isSideSolid(world, pos, EnumFacing.UP);
            }
            case Beach: {
                return !(!this.getSupportsGeneralPlants() && !this.getSupportsSandyPlants() || world.func_180495_p(pos.func_177974_f()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos.func_177976_e()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos.func_177978_c()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos.func_177968_d()).func_185904_a() != Material.field_151586_h);
            }
        }
        return false;
    }
}

