/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.enderbook;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderBook
extends BaseItem
implements IHasRecipe,
IContent {
    private static final String KEY_BACKCOUNTER = "backCounter";
    public static String KEY_LOC = "location";
    public static String KEY_LARGEST = "loc_largest";
    public static int maximumSaved;
    public static float expDistRatio;
    public static final int BTNS_PER_COLUMN = 8;
    private static final String KEY_BACK = "location_back";
    public static final int BACK_TICKS = 600;
    private boolean enabled;

    public ItemEnderBook() {
        this.func_77625_d(1);
    }

    public static ArrayList<BlockPosDim> getLocations(ItemStack itemStack) {
        ArrayList<BlockPosDim> list = new ArrayList<BlockPosDim>();
        int end = ItemEnderBook.getLargestSlot(itemStack);
        for (int i = 0; i <= end; ++i) {
            String KEY = KEY_LOC + "_" + i;
            String csv = UtilNBT.getItemStackNBT(itemStack).func_74779_i(KEY);
            if (csv == null || csv.isEmpty()) continue;
            list.add(new BlockPosDim(csv));
        }
        return list;
    }

    private static int getLocationsCount(ItemStack itemStack) {
        return ItemEnderBook.getLocations(itemStack).size();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(UtilChat.lang(this.getTooltip()) + ItemEnderBook.getLocationsCount(stack));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.countdownBackTimer(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    private void countdownBackTimer(ItemStack stack) {
        int counter = ItemEnderBook.getBackTimer(stack);
        if (counter > 0) {
            UtilNBT.setItemStackNBTVal(stack, KEY_BACKCOUNTER, counter - 1);
        } else {
            UtilNBT.getItemStackNBT(stack).func_74778_a(KEY_BACK, "");
        }
    }

    public static int getBackTimer(ItemStack stack) {
        return UtilNBT.getItemStackNBTVal(stack, KEY_BACKCOUNTER);
    }

    public static void clearBackTimer(ItemStack stack) {
        UtilNBT.setItemStackNBTVal(stack, KEY_BACKCOUNTER, 0);
        stack.func_77978_p().func_74778_a(KEY_BACK, "");
    }

    public static void startBackTimer(ItemStack stack, BlockPosDim loc) {
        UtilNBT.setItemStackNBTVal(stack, KEY_BACKCOUNTER, 600);
        stack.func_77978_p().func_74778_a(KEY_BACK, loc.toCSV());
    }

    public static int getLargestSlot(ItemStack itemStack) {
        return UtilNBT.getItemStackNBT(itemStack).func_74762_e(KEY_LARGEST);
    }

    public static int getEmptySlotAndIncrement(ItemStack itemStack) {
        int empty = UtilNBT.getItemStackNBT(itemStack).func_74762_e(KEY_LARGEST);
        if (empty == 0) {
            empty = 1;
        }
        UtilNBT.getItemStackNBT(itemStack).func_74768_a(KEY_LARGEST, empty + 1);
        return empty;
    }

    public static ItemStack getPlayersBook(EntityPlayer player) {
        ItemStack book = player.func_184586_b(EnumHand.MAIN_HAND);
        if (book == null || !(book.func_77973_b() instanceof ItemEnderBook)) {
            book = player.func_184586_b(EnumHand.OFF_HAND);
        }
        UtilNBT.getItemStackNBT(book);
        return book;
    }

    public static void deleteWaypoint(EntityPlayer player, int slot) {
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        book.func_77978_p().func_82580_o(KEY_LOC + "_" + slot);
    }

    public static void saveCurrentLocation(EntityPlayer player, String name) {
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        int id = ItemEnderBook.getEmptySlotAndIncrement(book);
        BlockPosDim loc = new BlockPosDim(id, player, name);
        book.func_77978_p().func_74778_a(KEY_LOC + "_" + id, loc.toCSV());
    }

    static BlockPosDim getBackLocation(ItemStack stack) {
        String csv = stack.func_77978_p().func_74779_i(KEY_BACK);
        if (csv == null || csv.isEmpty()) {
            return null;
        }
        return new BlockPosDim(csv);
    }

    static BlockPosDim getLocation(ItemStack stack, int slot) {
        String csv = stack.func_77978_p().func_74779_i(KEY_LOC + "_" + slot);
        if (csv == null || csv.isEmpty()) {
            return null;
        }
        return new BlockPosDim(csv);
    }

    public static BlockPos getLocationPos(ItemStack stack, int slot) {
        BlockPosDim loc = ItemEnderBook.getLocation(stack, slot);
        if (loc == null) {
            return null;
        }
        return new BlockPos(loc.getX(), loc.getY(), loc.getZ());
    }

    public static boolean teleport(EntityPlayer player, int slot) {
        boolean success;
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        BlockPosDim loc = ItemEnderBook.getLocation(book, slot);
        if (7777 == slot) {
            loc = ItemEnderBook.getBackLocation(book);
        }
        if (player.field_71093_bK != loc.getDimension()) {
            return false;
        }
        if (player instanceof EntityPlayerMP && (success = UtilEntity.enderTeleportEvent((EntityLivingBase)player, player.field_70170_p, loc.getX(), loc.getY() + 0.1, loc.getZ()))) {
            player.func_130014_f_().func_175726_f(new BlockPos(loc.getX(), loc.getY(), loc.getZ())).func_177427_f(true);
        }
        return true;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "ene", "ebe", "eee", Character.valueOf('e'), "enderpearl", Character.valueOf('b'), Items.field_151122_aG, Character.valueOf('n'), "blockEmerald");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityPlayer, EnumHand hand) {
        ItemStack stack = entityPlayer.func_184586_b(hand);
        if (stack == null || stack.func_77973_b() == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        entityPlayer.openGui((Object)ModCyclic.instance, 4, world, 0, 0, 0);
        return super.func_77659_a(world, entityPlayer, hand);
    }

    public static int getExpCostPerTeleport(EntityPlayer player, ItemStack book, int slot) {
        if (expDistRatio <= 0.0f) {
            return 0;
        }
        BlockPos toPos = ItemEnderBook.getLocationPos(book, slot);
        if (toPos == null) {
            return 0;
        }
        int distance = (int)UtilWorld.distanceBetweenHorizontal(toPos, player.func_180425_c());
        return Math.round((float)distance / expDistRatio);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.TRANSPORT);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public String getContentName() {
        return "book_ender";
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnderBook", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
        maximumSaved = config.getInt("EnderBookMaxSaved", "modpacks", 64, 1, 512, "Maximum number of saved waypoints in the ender book.  It still uses 8 per column, and putting too many may send it offscreen");
        expDistRatio = config.getFloat("EnderBookExpCostRatio", "modpacks", 10.0f, 0.0f, 100.0f, "The exp cost of teleporting is [the horizontal distance] divided by [this number] rounded to the nearest integer.  For example, if this number is 10, then teleporting 20 blocks costs 2 exp");
    }

    static {
        expDistRatio = 10.0f;
    }
}

