/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPaperCarbon
extends BaseItem
implements IHasRecipe,
IContent {
    public static final String name = "carbon_paper";
    public static int NOTE_EMPTY = -1;
    private static final String KEY_SIGN0 = "sign_0";
    private static final String KEY_SIGN1 = "sign_1";
    private static final String KEY_SIGN2 = "sign_2";
    private static final String KEY_SIGN3 = "sign_3";
    private static final String KEY_NOTE = "note";
    private boolean enabled;

    public ItemPaperCarbon() {
        this.func_77625_d(1);
    }

    private static void setItemStackNBT(ItemStack item, String prop, String value) {
        item.func_77978_p().func_74778_a(prop, value);
    }

    private static String getItemStackNBT(ItemStack item, String prop) {
        String s = item.func_77978_p().func_74779_i(prop);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public static void copySign(World world, EntityPlayer entityPlayer, TileEntitySign sign, ItemStack held) {
        if (held.func_77978_p() == null) {
            held.func_77982_d(new NBTTagCompound());
        }
        ItemPaperCarbon.setItemStackNBT(held, KEY_SIGN0, ITextComponent.Serializer.func_150696_a((ITextComponent)sign.field_145915_a[0]));
        ItemPaperCarbon.setItemStackNBT(held, KEY_SIGN1, ITextComponent.Serializer.func_150696_a((ITextComponent)sign.field_145915_a[1]));
        ItemPaperCarbon.setItemStackNBT(held, KEY_SIGN2, ITextComponent.Serializer.func_150696_a((ITextComponent)sign.field_145915_a[2]));
        ItemPaperCarbon.setItemStackNBT(held, KEY_SIGN3, ITextComponent.Serializer.func_150696_a((ITextComponent)sign.field_145915_a[3]));
        held.func_77978_p().func_74774_a(KEY_NOTE, (byte)NOTE_EMPTY);
    }

    public static void pasteSign(World world, EntityPlayer entityPlayer, TileEntitySign sign, ItemStack held) {
        if (held.func_77978_p() == null) {
            held.func_77982_d(new NBTTagCompound());
        }
        try {
            sign.field_145915_a[0] = ITextComponent.Serializer.func_150699_a((String)ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN0));
            sign.field_145915_a[1] = ITextComponent.Serializer.func_150699_a((String)ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN1));
            sign.field_145915_a[2] = ITextComponent.Serializer.func_150699_a((String)ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN2));
            sign.field_145915_a[3] = ITextComponent.Serializer.func_150699_a((String)ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN3));
            return;
        }
        catch (Exception exception) {
            sign.field_145915_a[0] = new TextComponentTranslation(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN0), new Object[0]);
            sign.field_145915_a[1] = new TextComponentTranslation(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN1), new Object[0]);
            sign.field_145915_a[2] = new TextComponentTranslation(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN2), new Object[0]);
            sign.field_145915_a[3] = new TextComponentTranslation(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN3), new Object[0]);
            return;
        }
    }

    public static void copyNote(World world, EntityPlayer entityPlayer, TileEntityNote noteblock, ItemStack held) {
        if (held.func_77978_p() == null) {
            held.func_77982_d(new NBTTagCompound());
        }
        held.func_77978_p().func_74774_a(KEY_NOTE, noteblock.field_145879_a);
    }

    public static void pasteNote(World world, EntityPlayer entityPlayer, TileEntityNote noteblock, ItemStack held) {
        if (held.func_77978_p() == null) {
            return;
        }
        if (held.func_77978_p().func_74771_c(KEY_NOTE) == NOTE_EMPTY) {
            return;
        }
        noteblock.field_145879_a = held.func_77978_p().func_74771_c(KEY_NOTE);
    }

    @Override
    public String getContentName() {
        return name;
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName());
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("CarbonPaper", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack held, World player, List<String> list, ITooltipFlag advanced) {
        String s;
        boolean isEmpty;
        boolean bl = isEmpty = held.func_77978_p() == null;
        if (isEmpty) {
            list.add(UtilChat.lang("item.carbon_paper.tooltip"));
            return;
        }
        String sign = ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN0) + ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN1) + ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN2) + ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN3);
        if (sign.length() > 0) {
            list.add(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN0));
            list.add(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN1));
            list.add(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN2));
            list.add(ItemPaperCarbon.getItemStackNBT(held, KEY_SIGN3));
        }
        if ((s = ItemPaperCarbon.noteToString(held.func_77978_p().func_74771_c(KEY_NOTE))) != null) {
            list.add(UtilChat.lang("item.carbon_paper.note") + s);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer entityPlayer, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        boolean isEmpty;
        TileEntity container = world.func_175625_s(pos);
        boolean isValid = false;
        ItemStack held = entityPlayer.func_184586_b(hand);
        boolean bl = isEmpty = held.func_77978_p() == null;
        if (container instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)container;
            if (isEmpty) {
                ItemPaperCarbon.copySign(world, entityPlayer, sign, held);
            } else {
                ItemPaperCarbon.pasteSign(world, entityPlayer, sign, held);
            }
            isValid = true;
        }
        if (container instanceof TileEntityNote) {
            TileEntityNote noteblock = (TileEntityNote)container;
            if (isEmpty) {
                ItemPaperCarbon.copyNote(world, entityPlayer, noteblock, held);
            } else {
                ItemPaperCarbon.pasteNote(world, entityPlayer, noteblock, held);
            }
            isValid = true;
        }
        if (isValid) {
            UtilParticle.spawnParticle(world, EnumParticleTypes.PORTAL, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            UtilSound.playSound(entityPlayer, pos, SoundEvents.field_187646_bt);
        }
        return EnumActionResult.PASS;
    }

    public static String noteToString(byte note) {
        String s = null;
        switch (note) {
            case 0: {
                s = TextFormatting.YELLOW + "F#";
                break;
            }
            case 1: {
                s = TextFormatting.YELLOW + "G";
                break;
            }
            case 2: {
                s = TextFormatting.YELLOW + "G#";
                break;
            }
            case 3: {
                s = TextFormatting.YELLOW + "A";
                break;
            }
            case 4: {
                s = TextFormatting.YELLOW + "A#";
                break;
            }
            case 5: {
                s = TextFormatting.RED + "B";
                break;
            }
            case 6: {
                s = TextFormatting.RED + "C";
                break;
            }
            case 7: {
                s = TextFormatting.DARK_RED + "C#";
                break;
            }
            case 8: {
                s = TextFormatting.DARK_RED + "D";
                break;
            }
            case 9: {
                s = TextFormatting.LIGHT_PURPLE + "D#";
                break;
            }
            case 10: {
                s = TextFormatting.LIGHT_PURPLE + "E";
                break;
            }
            case 11: {
                s = TextFormatting.DARK_PURPLE + "F";
                break;
            }
            case 12: {
                s = TextFormatting.DARK_PURPLE + "F#";
                break;
            }
            case 13: {
                s = TextFormatting.DARK_PURPLE + "G";
                break;
            }
            case 14: {
                s = TextFormatting.DARK_BLUE + "G#";
                break;
            }
            case 15: {
                s = TextFormatting.DARK_BLUE + "A";
                break;
            }
            case 16: {
                s = TextFormatting.BLUE + "A#";
                break;
            }
            case 17: {
                s = TextFormatting.BLUE + "B";
                break;
            }
            case 18: {
                s = TextFormatting.DARK_AQUA + "C";
                break;
            }
            case 19: {
                s = TextFormatting.AQUA + "C#";
                break;
            }
            case 20: {
                s = TextFormatting.AQUA + "D";
                break;
            }
            case 21: {
                s = TextFormatting.GREEN + "D#";
                break;
            }
            case 22: {
                s = TextFormatting.GREEN + "E";
                break;
            }
            case 23: {
                s = TextFormatting.AQUA + "F";
                break;
            }
            case 24: {
                s = TextFormatting.AQUA + "F#";
            }
        }
        return s;
    }

    @Override
    public IRecipe addRecipe() {
        RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), new ItemStack((Item)this));
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this, 8), "ppp", "pcp", "ppp", Character.valueOf('c'), new ItemStack(Items.field_151044_h, 1, 1), Character.valueOf('p'), "paper");
    }
}

