/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.component;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.ITooltipButton;
import com.lothrazar.cyclicmagic.net.PacketTileSetField;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiSliderInteger
extends GuiButtonExt
implements ITooltipButton {
    private float sliderPosition = 1.0f;
    public boolean isMouseDown;
    private final int min;
    private final int max;
    private final TileEntityBaseMachineInvo responder;
    private int responderField;
    private boolean appendPlusSignLabel = true;
    private List<String> tooltip = new ArrayList<String>();
    private String tooltipOriginal;

    public GuiSliderInteger(TileEntityBaseMachineInvo guiResponder, int idIn, int x, int y, int widthIn, int heightIn, int minIn, int maxIn, int fieldId) {
        this(guiResponder, idIn, x, y, widthIn, heightIn, minIn, maxIn, fieldId, "");
    }

    public GuiSliderInteger(TileEntityBaseMachineInvo guiResponder, int idIn, int x, int y, int widthIn, int heightIn, int minIn, int maxIn, int fieldId, String tooltip) {
        super(idIn, x, y, widthIn, heightIn, "");
        this.updateDisplay();
        this.responder = guiResponder;
        this.min = minIn;
        this.max = maxIn;
        this.responderField = fieldId;
        this.appendPlusSignLabel = this.getMin() < 0;
        this.setSliderValue(this.responder.func_174887_a_(this.responderField), false);
        this.tooltipOriginal = tooltip;
    }

    public void setSliderValue(float value, boolean notifyResponder) {
        this.sliderPosition = (value - (float)this.getMin()) / (float)(this.getMax() - this.getMin());
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > (float)this.getMax()) {
            this.sliderPosition = this.getMax();
        }
        this.updateDisplay();
        if (notifyResponder) {
            this.notifyResponder();
        }
    }

    private void notifyResponder() {
        int val = (int)this.getSliderValue();
        this.responder.func_174885_b(this.responderField, val);
        ModCyclic.network.sendToServer((IMessage)new PacketTileSetField(this.responder.func_174877_v(), this.responderField, (int)this.getSliderValue()));
    }

    public float getSliderValue() {
        float val = (float)this.getMin() + (float)(this.getMax() - this.getMin()) * this.sliderPosition;
        return MathHelper.func_76141_d((float)val);
    }

    private void updateDisplay() {
        int val = (int)this.getSliderValue();
        this.field_146126_j = val > 0 && this.appendPlusSignLabel ? "+" + val : "" + val;
    }

    public void setTooltip(String t) {
        this.tooltipOriginal = t;
        ArrayList<String> remake = new ArrayList<String>();
        remake.add(UtilChat.lang(t));
        if (this.func_146115_a()) {
            remake.add(TextFormatting.GRAY + UtilChat.lang("pump.secondline") + this.amt());
        }
        this.tooltip = remake;
    }

    @Override
    public List<String> getTooltips() {
        return this.tooltip;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.sliderPosition = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.updateDisplay();
            this.notifyResponder();
            this.isMouseDown = true;
            return true;
        }
        return false;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        super.func_146119_b(mc, mouseX, mouseY);
        if (this.field_146125_m) {
            if (this.isMouseDown) {
                this.sliderPosition = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                if (this.sliderPosition < 0.0f) {
                    this.sliderPosition = 0.0f;
                }
                if (this.sliderPosition > 1.0f) {
                    this.sliderPosition = 1.0f;
                }
                this.updateDisplay();
                this.notifyResponder();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderPosition * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderPosition * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, this.field_146121_g);
        }
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        this.isMouseDown = false;
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int amt() {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            return 5;
        }
        if (Keyboard.isKeyDown((int)184) || Keyboard.isKeyDown((int)56)) {
            return 25;
        }
        return 1;
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (this.func_146115_a()) {
            int dir = 0;
            if (keyCode == 30 || keyCode == 203) {
                dir = -1;
            } else if (keyCode == 32 || keyCode == 205) {
                dir = 1;
            }
            if (dir != 0 && this.getSliderValue() + (float)(dir * this.amt()) <= (float)this.getMax()) {
                this.setSliderValue(this.getSliderValue() + (float)(dir * this.amt()), true);
            }
        }
    }

    public void updateScreen() {
        this.setTooltip(this.tooltipOriginal);
    }
}

