/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.solidifier;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.block.core.IBlockHasTESR;
import com.lothrazar.cyclicmagic.block.solidifier.FluidSolidifierTESR;
import com.lothrazar.cyclicmagic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclicmagic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSolidifier
extends BlockBaseHasTile
implements IContent,
IHasRecipe,
IBlockHasTESR {
    private boolean enabled;

    public BlockSolidifier() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.setGuiId(54);
        this.setTranslucent();
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileSolidifier();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileSolidifier.class, (TileEntitySpecialRenderer)new FluidSolidifierTESR());
    }

    @Override
    public IRecipe addRecipe() {
        RecipeSolidifier.initAllRecipes();
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), " s ", "lgl", "ooo", Character.valueOf('l'), Blocks.field_150392_bi, Character.valueOf('o'), "dustGlowstone", Character.valueOf('g'), "blockIron", Character.valueOf('s'), Blocks.field_190976_dk);
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileSolidifier) {
            float fill = ((TileSolidifier)te).getFillRatio();
            return (int)(15.0f * fill);
        }
        return 0;
    }

    @Override
    public String getContentName() {
        return "solidifier";
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, this.getContentName(), GuideCategory.BLOCKMACHINE);
        BlockRegistry.registerTileEntity(TileSolidifier.class, this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
    }
}

