/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.scaffolding;

import com.lothrazar.cyclicmagic.block.core.BlockBase;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockScaffolding
extends BlockBase
implements IHasRecipe {
    private static final double CLIMB_SPEED = 0.31;
    private static final double OFFSET = 0.0125;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0125, 0.0, 0.0125, 0.9875, 1.0, 0.9875);
    protected boolean dropBlock = true;
    private boolean doesAutobreak = true;

    public BlockScaffolding(boolean autoBreak) {
        super(Material.field_151592_s);
        this.doesAutobreak = autoBreak;
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        SoundEvent zero = SoundRegistry.block_scaffolding;
        this.func_149672_a(new SoundType(0.1f, 1.0f, zero, zero, zero, zero, zero));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public void func_180650_b(World worldObj, BlockPos pos, IBlockState state, Random rand) {
        if (this.doesAutobreak && worldObj.field_73012_v.nextDouble() < 0.5) {
            worldObj.func_175655_b(pos, this.dropBlock);
        }
    }

    public int func_149738_a(World worldIn) {
        return 200;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 16), "s s", " s ", "s s", Character.valueOf('s'), "stickWood");
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)entityIn;
        if (!entityIn.field_70123_F) {
            return;
        }
        UtilEntity.tryMakeEntityClimb(worldIn, entity, 0.31);
    }
}

