/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.harvester;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.harvester.BlockHarvester;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilHarvester;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHarvester
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITilePreviewToggle,
ITickable {
    private static final int MAX_SIZE = 7;
    private int size = 7;
    public static int TIMER_FULL = 200;
    private int normalModeIfZero = 0;

    public TileEntityHarvester() {
        super(27);
        this.initEnergy(new EnergyStore(64000, 64000, 64000), BlockHarvester.FUEL_COST);
        this.timer = TIMER_FULL;
        this.setSlotsForExtract(0, this.func_70302_i_());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.size = tags.func_74762_e("size");
        this.needsRedstone = tags.func_74762_e("redstone");
        this.renderParticles = tags.func_74762_e("render");
        this.normalModeIfZero = tags.func_74762_e("HM");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("redstone", this.needsRedstone);
        tags.func_74768_a("render", this.renderParticles);
        tags.func_74768_a("size", this.size);
        tags.func_74768_a("HM", this.normalModeIfZero);
        return super.func_189515_b(tags);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (this.isInventoryFull()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        if (this.updateTimerIsZero()) {
            this.timer = TIMER_FULL;
            if (this.normalModeIfZero == 0) {
                if (!this.tryHarvestSingle(this.getTargetPos())) {
                    this.timer = 1;
                }
            } else {
                this.tryHarvestArea();
            }
        }
    }

    private void tryHarvestArea() {
        List<BlockPos> shape = this.getShapeFilled();
        for (BlockPos posCurrent : shape) {
            this.tryHarvestSingle(posCurrent);
            if (!this.isInventoryFull()) continue;
            return;
        }
    }

    private boolean tryHarvestSingle(BlockPos harvestPos) {
        NonNullList<ItemStack> drops = UtilHarvester.harvestSingle(this.func_145831_w(), harvestPos);
        if (drops.size() > 0) {
            this.updateEnergyIsBurning();
            if (this.isPreviewVisible()) {
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.DRAGON_BREATH, harvestPos);
            }
            this.setOutputItems((List<ItemStack>)drops);
            return true;
        }
        return false;
    }

    private void setOutputItems(List<ItemStack> output) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(output, this, 0, this.func_70302_i_());
        if (!toDrop.isEmpty()) {
            for (ItemStack s : toDrop) {
                UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.func_174877_v().func_177984_a(), s);
            }
        }
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1);
    }

    private BlockPos getTargetPos() {
        return UtilWorld.getRandomPos(this.func_145831_w().field_73012_v, this.getTargetCenter(), this.size);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(this.func_174890_g());
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SIZE: {
                return this.size;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case HARVESTMODE: {
                return this.normalModeIfZero;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case SIZE: {
                if (value > 7) {
                    value = 0;
                }
                if (value < 0) {
                    value = 7;
                }
                this.size = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
                break;
            }
            case HARVESTMODE: {
                this.normalModeIfZero = value % 2;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public List<BlockPos> getShape() {
        return UtilShape.squareHorizontalHollow(this.getTargetCenter(), this.size);
    }

    private List<BlockPos> getShapeFilled() {
        return UtilShape.squareHorizontalFull(this.getTargetCenter(), this.size);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        SIZE,
        RENDERPARTICLES,
        HARVESTMODE;

    }
}

