/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.dehydrator;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.dehydrator.BlockDeHydrator;
import com.lothrazar.cyclicmagic.block.dehydrator.RecipeDeHydrate;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityDeHydrator
extends TileEntityBaseMachineFluid
implements ITileRedstoneToggle,
ITickable {
    static final int SLOT_RECIPE = 0;
    public static final int STASH_SIZE = 4;
    public static final int TANK_FULL = 16000;
    private int timerMax = 1;
    private RecipeDeHydrate lastRecipe = null;
    private InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerDummyHydrator(), 1, 1);

    public TileEntityDeHydrator() {
        super(9);
        this.tank = new FluidTankFixDesync(16000, this);
        this.tank.setTileEntity(this);
        this.tank.setFluidAllowed(FluidRegistry.WATER);
        this.setSlotsForInsert(1, 4);
        this.setSlotsForExtract(5, 8);
        this.initEnergy(new EnergyStore(64000, 64000, 64000), BlockDeHydrator.FUEL_COST);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return this.getFieldOrdinals().length;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.tryShiftInput();
        if (this.func_70301_a(0).func_190926_b()) {
            this.lastRecipe = null;
        }
        if (this.lastRecipe == null) {
            this.lastRecipe = this.findMatchingRecipe();
        }
        if (this.lastRecipe == null) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        if (this.updateTimerIsZero() && !this.func_70301_a(0).func_190926_b() && this.tryProcessRecipe()) {
            if (this.func_70301_a(0).func_190926_b()) {
                this.lastRecipe = null;
            } else {
                this.timer = this.lastRecipe.getTime();
            }
        }
    }

    private void tryShiftInput() {
        for (int i = 1; i <= 4; ++i) {
            ItemStack result = this.tryMergeStackIntoSlot(this.func_70301_a(i), 0);
            this.func_70299_a(i, result);
        }
    }

    public boolean tryProcessRecipe() {
        if (!this.recipeMatches(this.lastRecipe)) {
            this.lastRecipe = null;
            return false;
        }
        if (this.tank.getCapacity() == this.tank.getFluidAmount()) {
            return false;
        }
        if (this.lastRecipe.tryPayCost(this)) {
            this.tank.fill(new FluidStack(FluidRegistry.WATER, this.lastRecipe.getFluid()), true);
            this.sendOutputItem(this.lastRecipe.func_77571_b());
            return true;
        }
        return false;
    }

    private boolean recipeMatches(RecipeDeHydrate irecipe) {
        this.crafting.func_70299_a(0, this.func_70301_a(0).func_77946_l());
        return irecipe.func_77569_a(this.crafting, this.field_145850_b);
    }

    private RecipeDeHydrate findMatchingRecipe() {
        for (RecipeDeHydrate irecipe : RecipeDeHydrate.recipes) {
            if (!this.recipeMatches(irecipe)) continue;
            this.timerMax = this.timer = irecipe.getTime();
            return irecipe;
        }
        return null;
    }

    public void sendOutputItem(ItemStack itemstack) {
        for (int i = 5; i < this.func_70302_i_(); ++i) {
            if (itemstack.func_190926_b() || itemstack.func_77976_d() == 0) continue;
            itemstack = this.tryMergeStackIntoSlot(itemstack, i);
        }
        if (!itemstack.func_190926_b() && itemstack.func_77976_d() != 0) {
            UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.field_174879_c.func_177984_a(), itemstack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case TIMERMAX: {
                return this.timerMax;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case TIMERMAX: {
                this.timerMax = value;
                break;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public float getFillRatio() {
        return this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    public static class ContainerDummyHydrator
    extends Container {
        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        TIMERMAX;

    }
}

