/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablepump;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.lothrazar.cyclicmagic.block.IFacingBlacklist;
import com.lothrazar.cyclicmagic.block.cable.BlockCableBase;
import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.cablepump.TileEntityBasePump;
import com.lothrazar.cyclicmagic.block.core.BlockBaseFacingOmni;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class BlockPump
extends BlockBaseFacingOmni {
    private static final double SIZE = 0.875;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
    protected static final Map<EnumFacing, PropertyEnum<EnumConnectType>> PROPERTIES = Maps.newEnumMap((Map)new ImmutableMap.Builder().put((Object)EnumFacing.DOWN, (Object)PropertyEnum.func_177709_a((String)"down", EnumConnectType.class)).put((Object)EnumFacing.UP, (Object)PropertyEnum.func_177709_a((String)"up", EnumConnectType.class)).put((Object)EnumFacing.NORTH, (Object)PropertyEnum.func_177709_a((String)"north", EnumConnectType.class)).put((Object)EnumFacing.SOUTH, (Object)PropertyEnum.func_177709_a((String)"south", EnumConnectType.class)).put((Object)EnumFacing.WEST, (Object)PropertyEnum.func_177709_a((String)"west", EnumConnectType.class)).put((Object)EnumFacing.EAST, (Object)PropertyEnum.func_177709_a((String)"east", EnumConnectType.class)).build());
    private boolean itemTransport = false;
    private boolean fluidTransport = false;
    private boolean powerTransport = false;

    public BlockPump() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.5f);
        this.setTranslucent();
        this.placeType = BlockBaseFacingOmni.PlacementType.SIDE_BLOCK;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void setItemTransport() {
        this.itemTransport = true;
    }

    public void setFluidTransport() {
        this.fluidTransport = true;
    }

    public void setPowerTransport() {
        this.powerTransport = true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        for (PropertyEnum<EnumConnectType> property : PROPERTIES.values()) {
            builder.add(new IProperty[]{property});
        }
        builder.add(new IProperty[]{BlockDirectional.field_176387_N});
        return builder.build();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityBasePump te = (TileEntityBasePump)world.func_175625_s(pos);
        if (te != null && BlockCableBase.isWrenchItem(player.func_184586_b(hand))) {
            EnumFacing sideToToggle = null;
            sideToToggle = hitX < 0.2f ? EnumFacing.WEST : (hitX > 0.8f ? EnumFacing.EAST : (hitY < 0.2f ? EnumFacing.DOWN : (hitY > 0.8f ? EnumFacing.UP : (hitZ < 0.2f ? EnumFacing.NORTH : (hitZ > 0.8f ? EnumFacing.SOUTH : side)))));
            if (sideToToggle != null) {
                te.toggleBlacklist(sideToToggle);
                boolean theNew = te.getBlacklist(sideToToggle);
                world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTIES.get(sideToToggle), (Comparable)((Object)(theNew ? EnumConnectType.BLOCKED : EnumConnectType.NONE))));
                UtilChat.sendStatusMessage(player, UtilChat.lang("cable.block.toggled." + theNew) + sideToToggle.name().toLowerCase());
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos origin) {
        BlockPos pos = new BlockPos((Vec3i)origin);
        IFacingBlacklist pumpHere = (IFacingBlacklist)world.func_175625_s(pos);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            PropertyEnum<EnumConnectType> property = PROPERTIES.get(side);
            if (pumpHere != null && pumpHere.getBlacklist(side)) {
                state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.BLOCKED));
                continue;
            }
            pos = origin.func_177972_a(side);
            state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.NONE));
            TileEntity tileTarget = world.func_175625_s(pos);
            TileEntityCableBase tileCable = null;
            if (tileTarget != null && tileTarget instanceof TileEntityCableBase) {
                tileCable = (TileEntityCableBase)tileTarget;
            }
            if (tileCable != null && tileCable.getBlacklist(side.func_176734_d())) continue;
            if (this.powerTransport) {
                if (tileCable != null && tileCable.isEnergyPipe()) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
                }
                if (tileTarget != null && tileTarget.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
                }
            }
            if (this.itemTransport) {
                if (tileCable != null && tileCable.isItemPipe()) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
                }
                if (tileTarget != null && tileTarget.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
                }
            }
            if (!this.fluidTransport) continue;
            if (tileCable != null && tileCable.isFluidPipe()) {
                state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
            }
            if (tileTarget == null || !tileTarget.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) continue;
            state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
        }
        return super.func_176221_a(state, world, origin);
    }

    public static enum EnumConnectType implements IStringSerializable
    {
        NONE,
        CABLE,
        BLOCKED;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

