/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.beaconempty;

import com.google.common.collect.Lists;
import com.lothrazar.cyclicmagic.block.beaconempty.BeamSegment;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBeaconPowered
extends TileEntityBaseMachineInvo
implements ITickable {
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;
    private final List<BeamSegment> beamSegments = Lists.newArrayList();
    private String customName;

    public TileEntityBeaconPowered() {
        super(0);
        this.setSetRenderGlobally(true);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.updateBeacon();
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)Blocks.field_150461_bJ, 1, 0);
        }
    }

    public void updateBeacon() {
        if (this.field_145850_b != null) {
            this.updateSegmentColors();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSegmentColors() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.beamSegments.clear();
        BeamSegment tileentitybeacon$beamsegment = new BeamSegment(EnumDyeColor.WHITE.func_193349_f());
        this.beamSegments.add(tileentitybeacon$beamsegment);
        boolean flag = true;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i1 = j + 1;
        while (i1 < 256) {
            block9: {
                float[] afloat;
                block6: {
                    IBlockState iblockstate;
                    block7: {
                        block8: {
                            block5: {
                                iblockstate = this.field_145850_b.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, i1, k));
                                if (iblockstate.func_177230_c() != Blocks.field_150399_cn) break block5;
                                afloat = ((EnumDyeColor)iblockstate.func_177229_b((IProperty)BlockStainedGlass.field_176547_a)).func_193349_f();
                                break block6;
                            }
                            if (iblockstate.func_177230_c() == Blocks.field_150397_co) break block7;
                            if (iblockstate.getLightOpacity((IBlockAccess)this.field_145850_b, (BlockPos)blockpos$mutableblockpos) >= 15 && iblockstate.func_177230_c() != Blocks.field_150357_h) {
                                this.beamSegments.clear();
                                return;
                            }
                            float[] customColor = iblockstate.func_177230_c().getBeaconColorMultiplier(iblockstate, this.field_145850_b, (BlockPos)blockpos$mutableblockpos, this.func_174877_v());
                            if (customColor == null) break block8;
                            afloat = customColor;
                            break block6;
                        }
                        tileentitybeacon$beamsegment.incrementHeight();
                        break block9;
                    }
                    afloat = ((EnumDyeColor)iblockstate.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a)).func_193349_f();
                }
                if (!flag) {
                    afloat = new float[]{(tileentitybeacon$beamsegment.getColors()[0] + afloat[0]) / 2.0f, (tileentitybeacon$beamsegment.getColors()[1] + afloat[1]) / 2.0f, (tileentitybeacon$beamsegment.getColors()[2] + afloat[2]) / 2.0f};
                }
                if (Arrays.equals(afloat, tileentitybeacon$beamsegment.getColors())) {
                    tileentitybeacon$beamsegment.incrementHeight();
                } else {
                    tileentitybeacon$beamsegment = new BeamSegment(afloat);
                    this.beamSegments.add(tileentitybeacon$beamsegment);
                }
                flag = false;
            }
            ++i1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BeamSegment> getBeamSegments() {
        return this.beamSegments;
    }

    @SideOnly(value=Side.CLIENT)
    public float shouldBeamRender() {
        if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return 0.0f;
        }
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setName(String name) {
        this.customName = name;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() != null && stack.func_77973_b().isBeaconPayment(stack);
    }

    public String getGuiID() {
        return "minecraft:beacon";
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBeacon((IInventory)playerInventory, (IInventory)this);
    }

    @Override
    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.updateBeacon();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }
}

