/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.lunarevents;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.lunarevents.LunarEvent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class StarShower
extends LunarEvent {
    private final LunarEvent.ConfigImpl config = new LunarEvent.ConfigImpl(this, () -> Config.starShowers);

    public StarShower(NyxWorld nyxWorld) {
        super("star_shower", nyxWorld);
    }

    @Override
    public ITextComponent getStartMessage() {
        return new TextComponentTranslation("info.nyx.star_shower", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD).func_150217_b(Boolean.valueOf(true)));
    }

    @Override
    public boolean shouldStart(boolean lastDaytime) {
        if (!lastDaytime || NyxWorld.isDaytime(this.world)) {
            return false;
        }
        return this.config.canStart();
    }

    @Override
    public boolean shouldStop(boolean lastDaytime) {
        return NyxWorld.isDaytime(this.world);
    }

    @Override
    public int getSkyColor() {
        return Config.colorStarShower;
    }

    @Override
    public void update(boolean lastDaytime) {
        this.config.update(lastDaytime);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return this.config.serializeNBT();
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.config.deserializeNBT(nbt);
    }
}

