/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.lunarevents;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.lunarevents.LunarEvent;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class HarvestMoon
extends LunarEvent {
    private final LunarEvent.ConfigImpl config = new LunarEvent.ConfigImpl(this, () -> Config.harvestMoon);

    public HarvestMoon(NyxWorld nyxWorld) {
        super("harvest_moon", nyxWorld);
    }

    @Override
    public ITextComponent getStartMessage() {
        return new TextComponentTranslation("info.nyx.harvest_moon", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150217_b(Boolean.valueOf(true)));
    }

    @Override
    public boolean shouldStart(boolean lastDaytime) {
        if (Config.harvestMoonOnFull && this.world.func_130001_d() < 1.0f) {
            return false;
        }
        if (!lastDaytime || NyxWorld.isDaytime(this.world)) {
            return false;
        }
        return this.config.canStart();
    }

    @Override
    public boolean shouldStop(boolean lastDaytime) {
        return NyxWorld.isDaytime(this.world);
    }

    @Override
    public int getSkyColor() {
        return Config.colorHarvestMoon;
    }

    @Override
    public String getMoonTexture() {
        return "harvest_moon";
    }

    @Override
    public void update(boolean lastDaytime) {
        this.config.update(lastDaytime);
        if (this.world.field_72995_K || this.nyxWorld.currentEvent != this || Config.harvestMoonGrowAmount <= 0) {
            return;
        }
        if (this.world.func_82737_E() % (long)Config.harvestMoonGrowInterval != 0L) {
            return;
        }
        Iterator chunks = this.world.getPersistentChunkIterable(((WorldServer)this.world).func_184164_w().func_187300_b());
        while (chunks.hasNext()) {
            Chunk chunk = (Chunk)chunks.next();
            for (int i = 0; i < Config.harvestMoonGrowAmount; ++i) {
                int z;
                int y;
                int x = this.world.field_73012_v.nextInt(16);
                BlockPos pos = new BlockPos(chunk.field_76635_g * 16 + x, y = chunk.func_76611_b(x, z = this.world.field_73012_v.nextInt(16)), chunk.field_76647_h * 16 + z);
                IBlockState state = chunk.func_177435_g(pos);
                Block block = state.func_177230_c();
                if (!(block instanceof IGrowable) || block instanceof BlockGrass || block instanceof BlockTallGrass || block instanceof BlockDoublePlant) continue;
                try {
                    IGrowable growable = (IGrowable)block;
                    if (!growable.func_176473_a(this.world, pos, state, false)) continue;
                    growable.func_176474_b(this.world, this.world.field_73012_v, pos, state);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return this.config.serializeNBT();
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.config.deserializeNBT(nbt);
    }
}

