/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.lunarevents;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.lunarevents.LunarEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BloodMoon
extends LunarEvent {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private final Set<ChunkPos> eligibleChunksForSpawning = Sets.newHashSet();
    private final LunarEvent.ConfigImpl config = new LunarEvent.ConfigImpl(this, () -> Config.bloodMoon);

    public BloodMoon(NyxWorld nyxWorld) {
        super("blood_moon", nyxWorld);
    }

    @Override
    public ITextComponent getStartMessage() {
        return new TextComponentTranslation("info.nyx.blood_moon", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED).func_150217_b(Boolean.valueOf(true)));
    }

    @Override
    public boolean shouldStart(boolean lastDaytime) {
        if (Config.bloodMoonOnFull && this.world.func_130001_d() < 1.0f) {
            return false;
        }
        if (!lastDaytime || NyxWorld.isDaytime(this.world)) {
            return false;
        }
        return this.config.canStart();
    }

    @Override
    public boolean shouldStop(boolean lastDaytime) {
        return NyxWorld.isDaytime(this.world);
    }

    @Override
    public int getSkyColor() {
        return Config.colorBloodMoon;
    }

    @Override
    public String getMoonTexture() {
        return "blood_moon";
    }

    @Override
    public void update(boolean lastDaytime) {
        this.config.update(lastDaytime);
        if (this.nyxWorld.currentEvent == this && !this.world.field_72995_K && Config.bloodMoonSpawnMultiplier > 1) {
            WorldServer world;
            this.findChunksForSpawning(world, true, false, (world = (WorldServer)this.world).func_82737_E() % 400L == 0L);
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return this.config.serializeNBT();
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.config.deserializeNBT(nbt);
    }

    private int findChunksForSpawning(WorldServer worldServerIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        int i = 0;
        for (EntityPlayer entityplayer : worldServerIn.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int i1 = -8; i1 <= 8; ++i1) {
                for (int j1 = -8; j1 <= 8; ++j1) {
                    PlayerChunkMapEntry playerchunkmapentry;
                    boolean flag = i1 == -8 || i1 == 8 || j1 == -8 || j1 == 8;
                    ChunkPos chunkpos = new ChunkPos(i1 + j, j1 + k);
                    if (this.eligibleChunksForSpawning.contains(chunkpos)) continue;
                    ++i;
                    if (flag || !worldServerIn.func_175723_af().func_177730_a(chunkpos) || (playerchunkmapentry = worldServerIn.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e()) continue;
                    this.eligibleChunksForSpawning.add(chunkpos);
                }
            }
        }
        int j4 = 0;
        BlockPos blockpos1 = worldServerIn.func_175694_M();
        for (EnumCreatureType enumcreaturetype : EnumCreatureType.values()) {
            int l4;
            int k4;
            if (enumcreaturetype.func_75599_d() && !spawnPeacefulMobs || !enumcreaturetype.func_75599_d() && !spawnHostileMobs || enumcreaturetype.func_82705_e() && !spawnOnSetTickRate || (k4 = worldServerIn.countEntities(enumcreaturetype, true)) > (l4 = enumcreaturetype.func_75601_b() * Config.bloodMoonSpawnMultiplier * i / MOB_COUNT_DIV)) continue;
            ArrayList shuffled = Lists.newArrayList(this.eligibleChunksForSpawning);
            Collections.shuffle(shuffled);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            block6: for (ChunkPos chunkpos1 : shuffled) {
                BlockPos blockpos = BloodMoon.getRandomChunkPosition((World)worldServerIn, chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                int k1 = blockpos.func_177958_n();
                int l1 = blockpos.func_177956_o();
                int i2 = blockpos.func_177952_p();
                IBlockState iblockstate = worldServerIn.func_180495_p(blockpos);
                if (iblockstate.func_185915_l()) continue;
                int j2 = 0;
                block7: for (int k2 = 0; k2 < 3; ++k2) {
                    int l2 = k1;
                    int i3 = l1;
                    int j3 = i2;
                    Biome.SpawnListEntry entry = null;
                    IEntityLivingData ientitylivingdata = null;
                    int l3 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                    for (int i4 = 0; i4 < l3; ++i4) {
                        EntityLiving entityliving;
                        mutable.func_181079_c(l2 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6), i3 += worldServerIn.field_73012_v.nextInt(1) - worldServerIn.field_73012_v.nextInt(1), j3 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6));
                        float f = (float)l2 + 0.5f;
                        float f1 = (float)j3 + 0.5f;
                        if (worldServerIn.func_175636_b((double)f, (double)i3, (double)f1, (double)Config.bloodMoonSpawnRadius) || !(blockpos1.func_177954_c((double)f, (double)i3, (double)f1) >= 576.0)) continue;
                        if (entry == null && (entry = worldServerIn.func_175734_a(enumcreaturetype, (BlockPos)mutable)) == null) continue block7;
                        if (!worldServerIn.func_175732_a(enumcreaturetype, entry, (BlockPos)mutable) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)entry.field_76300_b), (World)worldServerIn, (BlockPos)mutable)) continue;
                        try {
                            entityliving = entry.newInstance((World)worldServerIn);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return j4;
                        }
                        ResourceLocation name = EntityList.func_191301_a((Entity)entityliving);
                        if (name == null || Config.isMobDuplicationWhitelist != Config.mobDuplicationBlacklist.contains(name.toString())) {
                            entry = null;
                            continue;
                        }
                        entityliving.getEntityData().func_74757_a("nyx:blood_moon_spawn", true);
                        entityliving.func_70012_b((double)f, (double)i3, (double)f1, worldServerIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)worldServerIn, (float)f, (float)i3, (float)f1, (boolean)false);
                        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi() && entityliving.func_70058_J()) {
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)worldServerIn, (float)f, (float)i3, (float)f1)) {
                                ientitylivingdata = entityliving.func_180482_a(worldServerIn.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata);
                            }
                            if (entityliving.func_70058_J()) {
                                ++j2;
                                worldServerIn.func_72838_d((Entity)entityliving);
                            } else {
                                entityliving.func_70106_y();
                            }
                            if (j2 >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving)) continue block6;
                        }
                        j4 += j2;
                    }
                }
            }
        }
        return j4;
    }

    private static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }
}

