/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.items;

import com.google.common.collect.Multimap;
import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Scythe
extends Item {
    public Scythe() {
        this.func_77656_e(3450);
        this.func_77625_d(1);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        World worldIn = player.field_70170_p;
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof IPlantable) && !block.isLeaves(state, (IBlockAccess)worldIn, pos)) {
            return false;
        }
        if (block instanceof BlockCrops && !((BlockCrops)block).func_185525_y(state)) {
            return false;
        }
        int range = 4;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos offset = pos.func_177982_a(x, y, z);
                    IBlockState offState = worldIn.func_180495_p(offset);
                    Block offBlock = offState.func_177230_c();
                    if (!(offBlock instanceof IPlantable) && !offBlock.isLeaves(offState, (IBlockAccess)worldIn, offset)) continue;
                    NonNullList drops = NonNullList.func_191196_a();
                    offBlock.getDrops(drops, (IBlockAccess)worldIn, offset, offState, 0);
                    float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)offset, (IBlockState)offState, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player);
                    for (ItemStack drop : drops) {
                        if (Config.scytheDropBlacklist.stream().anyMatch(i -> i.func_77973_b().equals(drop.func_77973_b()) && i.func_77960_j() == drop.func_77960_j()) || worldIn.field_73012_v.nextFloat() > chance) continue;
                        for (String s : Config.scytheDropChances) {
                            String[] split = s.split(";");
                            if (!(worldIn.field_73012_v.nextDouble() <= MathHelper.func_82712_a((String)split[0], (double)-1.0))) continue;
                            Scythe.multCount(drop, MathHelper.func_82715_a((String)split[1], (int)1));
                            break;
                        }
                        Block.func_180635_a((World)worldIn, (BlockPos)offset, (ItemStack)drop);
                    }
                    worldIn.func_175655_b(offset, false);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Item.func_150898_a((Block)Registry.crystal);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 10.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.8, 0));
        }
        return multimap;
    }

    private static void multCount(ItemStack stack, int mult) {
        int newAmount = Math.min(stack.func_77976_d(), stack.func_190916_E() * mult);
        stack.func_190920_e(newAmount);
    }
}

