/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.items;

import de.ellpeck.nyx.Nyx;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.items.MeteorPickaxe;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;

public class MeteorHammer
extends MeteorPickaxe {
    public MeteorHammer(Item.ToolMaterial material) {
        super(material);
        this.func_77656_e(5500);
        this.field_77865_bY = 15.0f;
        this.field_185065_c = -3.2f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!entityLiving.field_70122_E) {
            return;
        }
        int useTime = this.func_77626_a(stack) - timeLeft;
        if (useTime < 20) {
            return;
        }
        if (entityLiving.field_70125_A > -10.0f) {
            return;
        }
        float modifier = MathHelper.func_76131_a((float)((float)(useTime - 20) / 5.0f), (float)1.0f, (float)2.5f);
        entityLiving.field_70159_w += (double)(-modifier * MathHelper.func_76126_a((float)(entityLiving.field_70177_z * ((float)Math.PI / 180))));
        entityLiving.field_70181_x += 0.625 * (double)modifier;
        entityLiving.field_70179_y += (double)(modifier * MathHelper.func_76134_b((float)(entityLiving.field_70177_z * ((float)Math.PI / 180))));
        entityLiving.getEntityData().func_74772_a("nyx:leap_start", worldIn.func_82737_E());
        if (!worldIn.field_72995_K) {
            worldIn.func_184133_a(null, entityLiving.func_180425_c(), Registry.hammerStartSound, SoundCategory.PLAYERS, 0.5f, 1.0f);
            ((WorldServer)worldIn).func_180505_a(EnumParticleTypes.FLAME, false, entityLiving.field_70165_t, entityLiving.field_70163_u + (double)entityLiving.func_70047_e(), entityLiving.field_70161_v, 30, 0.25, 0.25, 0.25, 0.05, new int[0]);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        double dist = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        RayTraceResult ray = MeteorHammer.getMovingObjectPosWithReachDistance(player.field_70170_p, player, dist, false, true, false);
        if (ray != null) {
            return this.breakBlocks(itemstack, 1, player.field_70170_p, pos, ray.field_178784_b, player);
        }
        return false;
    }

    private boolean breakBlocks(ItemStack stack, int radius, World world, BlockPos aPos, EnumFacing side, EntityPlayer player) {
        IBlockState theState;
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            zRange = radius;
            yRange = 0;
        }
        if (side.func_176740_k() == EnumFacing.Axis.X) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(aPos);
        float mainHardness = state.func_185887_b(world, aPos);
        if (!this.tryHarvestBlock(world, aPos, false, stack, player)) {
            return false;
        }
        if (radius == 2 && side.func_176740_k() != EnumFacing.Axis.Y && (theState = world.func_180495_p(aPos = aPos.func_177984_a())).func_185887_b(world, aPos) <= mainHardness + 5.0f) {
            this.tryHarvestBlock(world, aPos, true, stack, player);
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.func_177958_n() - xRange; xPos <= aPos.func_177958_n() + xRange; ++xPos) {
                for (int yPos = aPos.func_177956_o() - yRange; yPos <= aPos.func_177956_o() + yRange; ++yPos) {
                    for (int zPos = aPos.func_177952_p() - zRange; zPos <= aPos.func_177952_p() + zRange; ++zPos) {
                        BlockPos thePos;
                        IBlockState theState2;
                        if (aPos.func_177958_n() == xPos && aPos.func_177956_o() == yPos && aPos.func_177952_p() == zPos || !((theState2 = world.func_180495_p(thePos = new BlockPos(xPos, yPos, zPos))).func_185887_b(world, thePos) <= mainHardness + 5.0f)) continue;
                        this.tryHarvestBlock(world, thePos, true, stack, player);
                    }
                }
            }
        }
        return true;
    }

    private boolean tryHarvestBlock(World world, BlockPos pos, boolean isExtra, ItemStack stack, EntityPlayer player) {
        boolean canHarvest;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        float hardness = state.func_185887_b(world, pos);
        boolean bl = canHarvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || isExtra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !block.hasTileEntity(world.func_180495_p(pos)))) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return MeteorHammer.breakExtraBlock(stack, world, player, pos);
        }
        return false;
    }

    private static RayTraceResult getMovingObjectPosWithReachDistance(World world, EntityPlayer player, double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec31 = vec3.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return world.func_147447_a(vec3, vec31, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    private static boolean breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.field_71075_bZ.field_75098_d) {
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            stack.func_179548_a(world, state, pos, player);
            Nyx.proxy.sendBreakPacket(pos);
        }
        return true;
    }
}

