/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.events;

import com.google.common.collect.Streams;
import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.LunarWaterSource;
import de.ellpeck.nyx.Nyx;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.compat.InspirationsProxy;
import de.ellpeck.nyx.entities.CauldronTracker;
import de.ellpeck.nyx.entities.FallingMeteor;
import de.ellpeck.nyx.entities.FallingStar;
import de.ellpeck.nyx.entities.WolfAiSpecialMoon;
import de.ellpeck.nyx.items.LunarWaterBottle;
import de.ellpeck.nyx.lunarevents.BloodMoon;
import de.ellpeck.nyx.lunarevents.FullMoon;
import de.ellpeck.nyx.lunarevents.HarvestMoon;
import de.ellpeck.nyx.lunarevents.StarShower;
import de.ellpeck.nyx.network.PacketHandler;
import de.ellpeck.nyx.network.PacketNyxWorld;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.mutable.MutableInt;

@Mod.EventBusSubscriber(modid="nyx")
public final class Events {
    private static final AttributeModifier METEOR_MOVEMENT_MODIFIER = new AttributeModifier(UUID.fromString("c1f96acc-e117-4dc1-a351-e295a5de6071"), "nyx:meteor_movement_speed", (double)-0.15f, 2);

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (Config.meteors) {
            if (world.func_82737_E() % 20L == 0L) {
                boolean equipped;
                IAttributeInstance speed = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
                String key = "nyx:meteor_equipped";
                NBTTagCompound nbt = player.getEntityData();
                boolean bl = equipped = Streams.stream((Iterable)player.func_184193_aE()).filter(s -> s.func_77973_b() instanceof ItemArmor && ((ItemArmor)s.func_77973_b()).func_82812_d() == Registry.meteorArmorMaterial).count() >= 2L;
                if (equipped && !nbt.func_74767_n(key)) {
                    nbt.func_74757_a(key, true);
                    if (!speed.func_180374_a(METEOR_MOVEMENT_MODIFIER)) {
                        speed.func_111121_a(METEOR_MOVEMENT_MODIFIER);
                    }
                } else if (!equipped && nbt.func_74767_n(key)) {
                    nbt.func_74757_a(key, false);
                    speed.func_111124_b(METEOR_MOVEMENT_MODIFIER);
                }
            }
            if (player.field_70122_E && player.field_70143_R <= 0.0f && player.getEntityData().func_74764_b("nyx:leap_start")) {
                long leapTime;
                if (!world.field_72995_K && (leapTime = world.func_82737_E() - player.getEntityData().func_74763_f("nyx:leap_start")) >= 5L) {
                    int r = 3;
                    AxisAlignedBB area = new AxisAlignedBB(player.field_70165_t - (double)r, player.field_70163_u - (double)r, player.field_70161_v - (double)r, player.field_70165_t + (double)r, player.field_70163_u + (double)r, player.field_70161_v + (double)r);
                    DamageSource source = DamageSource.func_76365_a((EntityPlayer)player);
                    float damage = (float)Config.hammerDamage * Math.min((float)(leapTime - 5L) / 35.0f, 1.0f);
                    for (EntityLivingBase entity : world.func_175647_a(EntityLivingBase.class, area, EntitySelectors.field_94557_a)) {
                        if (entity == player) continue;
                        entity.func_70097_a(source, damage);
                        entity.field_70181_x = 1.0;
                    }
                    player.func_184185_a(Registry.hammerEndSound, 1.0f, 1.0f);
                }
                player.getEntityData().func_82580_o("nyx:leap_start");
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (Config.meteors && event.getEntityLiving().getEntityData().func_74764_b("nyx:leap_start")) {
            event.setDamageMultiplier(0.0f);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (Config.meteors && event.getSource().func_94541_c()) {
            int equipped = (int)Streams.stream((Iterable)event.getEntityLiving().func_184193_aE()).filter(s -> s.func_77973_b() instanceof ItemArmor && ((ItemArmor)s.func_77973_b()).func_82812_d() == Registry.meteorArmorMaterial).count();
            event.setAmount(event.getAmount() * (1.0f - 0.1f * (float)equipped));
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (Config.meteors) {
            ItemStack sword = event.getEntityLiving().func_184614_ca();
            if (sword.func_77973_b() != Registry.meteorSword) {
                return;
            }
            Entity target = event.getTarget();
            if (Config.meteorSwordStun && target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 30, 10, true, false));
            }
            if (target.field_70170_p.field_73012_v.nextDouble() < Config.meteorSwordExplosionChance) {
                target.field_70170_p.func_72876_a(event.getEntity(), target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70170_p.field_73012_v.nextFloat() * 0.6f + 1.5f, false);
            }
        }
    }

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        if (Config.meteors) {
            Entity attacker = event.getSource().func_76346_g();
            if (!(attacker instanceof EntityLivingBase)) {
                return;
            }
            ItemStack weapon = ((EntityLivingBase)attacker).func_184614_ca();
            if (weapon.func_77973_b() != Registry.meteorAxe) {
                return;
            }
            EntityLivingBase target = event.getEntityLiving();
            if (!(target instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)target;
            if (!player.func_184587_cr()) {
                return;
            }
            ItemStack active = player.func_184607_cu();
            if (active.func_77973_b() instanceof ItemShield) {
                active.func_77972_a(13, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        EntityPlayer selectedPlayer;
        int dimension;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        NyxWorld data = NyxWorld.get(event.world);
        if (data == null) {
            return;
        }
        data.update();
        if (!event.world.field_72995_K && Config.fallingStars && !NyxWorld.isDaytime(event.world) && event.world.func_82737_E() % 20L == 0L && Config.allowedDimensions.contains(dimension = event.world.field_73011_w.getDimension())) {
            for (EntityPlayer player : event.world.field_73010_i) {
                if ((double)event.world.field_73012_v.nextFloat() > (data.currentEvent instanceof StarShower ? Config.fallingStarRarityShower : Config.fallingStarRarity)) continue;
                BlockPos startPos = player.func_180425_c().func_177963_a(event.world.field_73012_v.nextGaussian() * 20.0, 0.0, event.world.field_73012_v.nextGaussian() * 20.0);
                startPos = event.world.func_175725_q(startPos).func_177981_b(MathHelper.func_76136_a((Random)event.world.field_73012_v, (int)32, (int)64));
                FallingStar star = new FallingStar(event.world);
                star.func_70107_b(startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p());
                event.world.func_72838_d((Entity)star);
            }
        }
        if (!event.world.field_72995_K && Config.meteors && event.world.func_82737_E() % 20L == 0L && event.world.field_73010_i.size() > 0 && (selectedPlayer = (EntityPlayer)event.world.field_73010_i.get(event.world.field_73012_v.nextInt(event.world.field_73010_i.size()))) != null) {
            double spawnX = selectedPlayer.field_70165_t + MathHelper.func_82716_a((Random)event.world.field_73012_v, (double)(-Config.meteorSpawnRadius), (double)Config.meteorSpawnRadius);
            double spawnZ = selectedPlayer.field_70161_v + MathHelper.func_82716_a((Random)event.world.field_73012_v, (double)(-Config.meteorSpawnRadius), (double)Config.meteorSpawnRadius);
            BlockPos spawnPos = new BlockPos(spawnX, 0.0, spawnZ);
            double chance = Config.getMeteorChance(event.world, data);
            MutableInt ticksInArea = data.playersPresentTicks.get(new ChunkPos(spawnPos));
            if (ticksInArea != null && ticksInArea.intValue() >= Config.meteorDisallowTime) {
                chance /= Math.pow(2.0, (double)ticksInArea.intValue() / (double)Config.meteorDisallowTime);
            }
            if (!(chance <= 0.0) && (double)event.world.field_73012_v.nextFloat() <= chance) {
                if (Config.meteorCacheEnabled && !event.world.func_175668_a(spawnPos, false)) {
                    data.cachedMeteorPositions.add(spawnPos);
                    data.sendToClients();
                } else {
                    FallingMeteor.spawn(data.world, spawnPos);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        NyxWorld data = NyxWorld.get(world);
        if (data == null) {
            return;
        }
        Chunk chunk = event.getChunk();
        ChunkPos cp = chunk.func_76632_l();
        if (Config.meteors && Config.meteorCacheEnabled) {
            Iterator<BlockPos> it = data.cachedMeteorPositions.iterator();
            while (it.hasNext()) {
                BlockPos bp = it.next();
                if (bp.func_177958_n() < cp.func_180334_c() || bp.func_177958_n() > cp.func_180332_e() || bp.func_177952_p() < cp.func_180333_d() || bp.func_177952_p() > cp.func_180330_f()) continue;
                FallingMeteor.spawn(data.world, bp);
                it.remove();
            }
            data.sendToClients();
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        NyxWorld data = NyxWorld.get(world);
        if (data == null) {
            return;
        }
        Chunk chunk = event.getChunk();
        for (ClassInheritanceMultiMap multiMap : chunk.func_177429_s()) {
            for (FallingMeteor meteor : multiMap.func_180215_b(FallingMeteor.class)) {
                if (!Config.meteorCacheEnabled) {
                    Nyx.LOGGER.debug("Events: Killed unloaded meteor");
                    meteor.func_70106_y();
                    continue;
                }
                BlockPos pos = new BlockPos(meteor.func_180425_c().func_177958_n(), 0, meteor.func_180425_c().func_177952_p());
                data.cachedMeteorPositions.add(pos);
                data.sendToClients();
                Nyx.LOGGER.debug("Events: Cached unloaded meteor");
                meteor.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        int currentLevel;
        BlockPos pos;
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (Config.bloodMoonVanish && !world.field_72995_K && NyxWorld.isDaytime(world) && entity.getEntityData().func_74767_n("nyx:blood_moon_spawn")) {
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 10, 0.5, 1.0, 0.5, 0.0, new int[0]);
            entity.func_70106_y();
            return;
        }
        if (Nyx.cauldronProxy instanceof InspirationsProxy && !world.field_72995_K && Nyx.cauldronProxy.isLunarWaterCauldron(world, pos = entity.func_180425_c()) && (currentLevel = Nyx.cauldronProxy.getLevel(world, pos)) > 0) {
            boolean did = false;
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
                did = true;
            }
            if (LunarWaterBottle.applyLunarWater(entity, LunarWaterSource.CAULDRON)) {
                did = true;
            }
            if (did) {
                Nyx.cauldronProxy.setLunarWaterCauldron(world, pos, currentLevel - 1);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        NyxWorld nyx = NyxWorld.get(world);
        if (nyx == null) {
            return;
        }
        if (entity instanceof EntityPlayerMP) {
            PacketNyxWorld packet = new PacketNyxWorld(nyx);
            PacketHandler.sendTo((EntityPlayer)((EntityPlayerMP)entity), packet);
        } else if (entity instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)entity;
            wolf.field_70715_bh.func_75776_a(3, (EntityAIBase)new WolfAiSpecialMoon((EntityTameable)wolf));
        }
    }

    @SubscribeEvent
    public static void onExpDrop(LivingExperienceDropEvent event) {
        if (Config.enchantments && !(Config.maxLunarEdgeXpMult <= 0.0)) {
            EntityPlayer player = event.getAttackingPlayer();
            if (player == null) {
                return;
            }
            ItemStack held = player.func_184614_ca();
            int level = EnchantmentHelper.func_77506_a((Enchantment)Registry.lunarEdge, (ItemStack)held);
            if (level <= 0) {
                return;
            }
            int exp = event.getDroppedExperience();
            float mod = (float)level / (float)Registry.lunarEdge.func_77325_b();
            mod = (float)((double)mod * Config.maxLunarEdgeXpMult);
            event.setDroppedExperience(exp + MathHelper.func_76141_d((float)((float)exp * mod)));
        }
    }

    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        List drops = event.getDrops();
        if (entity instanceof EntityElderGuardian && !entity.field_70170_p.field_72995_K && entity.field_70170_p.field_73012_v.nextDouble() <= Config.meteorShardGuardianChance) {
            ItemStack stack = new ItemStack(Registry.meteorShard, event.getLootingLevel() / 2 + 1);
            drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        NyxWorld nyx;
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof IMob) || entity instanceof EntitySlime) {
            return;
        }
        if (event.getSpawner() == null && (nyx = NyxWorld.get(entity.field_70170_p)) != null && nyx.currentEvent instanceof HarvestMoon) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof IMob)) {
            return;
        }
        NyxWorld nyx = NyxWorld.get(entity.field_70170_p);
        if (nyx == null) {
            return;
        }
        if (entity instanceof EntitySlime) {
            int i;
            EntitySlime slime = (EntitySlime)entity;
            int size = slime.func_70809_q();
            if (nyx.currentEvent instanceof FullMoon) {
                int i2 = slime.field_70170_p.field_73012_v.nextInt(5);
                if (i2 <= 1) {
                    size += 2;
                }
                if (i2 <= 2) {
                    size += 2;
                }
            } else if (nyx.currentEvent instanceof HarvestMoon && (i = slime.field_70170_p.field_73012_v.nextInt(15)) < 8) {
                size += i * 2;
            }
            if (size != slime.func_70809_q()) {
                slime.func_70799_a(size, true);
                event.setCanceled(true);
            }
        }
        if (nyx.currentEvent instanceof FullMoon) {
            if (Config.addPotionEffects && !(entity instanceof EntityCreeper)) {
                Potion effect = null;
                int i = entity.field_70170_p.field_73012_v.nextInt(20);
                if (i <= 2) {
                    effect = MobEffects.field_76424_c;
                } else if (i <= 4) {
                    effect = MobEffects.field_76420_g;
                } else if (i <= 6) {
                    effect = MobEffects.field_76428_l;
                } else if (i <= 7) {
                    effect = MobEffects.field_76441_p;
                }
                if (effect != null) {
                    entity.func_70690_d(new PotionEffect(effect, Integer.MAX_VALUE));
                }
            }
            if (Config.additionalMobsChance > 0 && entity.field_70170_p.field_73012_v.nextInt(Config.additionalMobsChance) == 0) {
                Events.doExtraSpawn((Entity)entity, "full_moon_spawn");
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("nyx".equals(event.getModID())) {
            Config.load();
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
        FluidStack fluid;
        ItemStack holding;
        int level;
        long time;
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        NyxWorld nyx = NyxWorld.get(world);
        if (Config.disallowDayEnchanting && ((time = world.func_72820_D() % 24000L) <= 13000L || time >= 23000L) && block instanceof BlockEnchantmentTable && !Config.enchantingWhitelistDimensions.contains(world.field_73011_w.getDimension())) {
            event.setUseBlock(Event.Result.DENY);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.nyx.day_enchanting", new Object[0]), true);
        }
        if (Config.lunarWater && !(Nyx.cauldronProxy instanceof InspirationsProxy) && block instanceof BlockCauldron && (level = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) <= 0 && !(holding = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && (fluid = FluidUtil.getFluidContained((ItemStack)holding)) != null && fluid.getFluid() == Registry.lunarWaterFluid && fluid.amount >= 1000) {
            level = 3;
            if (!world.field_72995_K) {
                if (!player.func_184812_l_()) {
                    player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(holding.func_77973_b()));
                }
                Nyx.cauldronProxy.setLunarWaterCauldron(world, pos, level);
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
        if (nyx != null && nyx.currentEvent instanceof BloodMoon && !Config.bloodMoonSleeping && block instanceof BlockBed) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.nyx.blood_moon_sleeping", new Object[0]), true);
        }
    }

    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof BlockCauldron)) {
            return;
        }
        if (!world.func_72872_a(CauldronTracker.class, new AxisAlignedBB(pos)).isEmpty()) {
            return;
        }
        CauldronTracker tracker = new CauldronTracker(world);
        tracker.setTrackingPos(pos);
        world.func_72838_d((Entity)tracker);
    }

    @SubscribeEvent
    public static void onWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("nyx", "world_cap"), (ICapabilityProvider)new NyxWorld((World)event.getObject()));
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        NyxWorld nyx = NyxWorld.get(player.field_70170_p);
        if (nyx != null && nyx.currentEvent instanceof BloodMoon && !Config.bloodMoonSleeping) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
    }

    private static void doExtraSpawn(Entity original, String key) {
        ResourceLocation name;
        String addedSpawnKey = "nyx:" + key;
        if (!original.getEntityData().func_74767_n(addedSpawnKey) && (name = EntityList.func_191301_a((Entity)original)) != null) {
            boolean listed = Config.mobDuplicationBlacklist.contains(name.toString());
            if (Config.isMobDuplicationWhitelist != listed) {
                return;
            }
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos offset;
                        if (x == 0 && y == 0 && z == 0 || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)original.field_70170_p, (BlockPos)(offset = original.func_180425_c().func_177982_a(x, y, z)))) continue;
                        Entity entity = EntityList.func_188429_b((ResourceLocation)name, (World)original.field_70170_p);
                        if (!(entity instanceof EntityLiving)) {
                            return;
                        }
                        EntityLiving living = (EntityLiving)entity;
                        entity.func_70012_b(original.field_70165_t + (double)x, original.field_70163_u + (double)y, original.field_70161_v + (double)z, MathHelper.func_76142_g((float)(original.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                        living.field_70759_as = living.field_70177_z;
                        living.field_70761_aq = living.field_70177_z;
                        living.getEntityData().func_74757_a(addedSpawnKey, true);
                        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)living, (World)original.field_70170_p, (float)((float)original.field_70165_t + (float)x), (float)((float)original.field_70163_u + (float)y), (float)((float)original.field_70161_v + (float)z), null)) {
                            living.func_180482_a(original.field_70170_p.func_175649_E(new BlockPos((Entity)living)), null);
                        }
                        original.field_70170_p.func_72838_d(entity);
                        return;
                    }
                }
            }
        }
    }
}

