/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.events;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.entities.CauldronTracker;
import de.ellpeck.nyx.entities.EmptyRenderer;
import de.ellpeck.nyx.entities.FallingMeteor;
import de.ellpeck.nyx.entities.FallingStar;
import de.ellpeck.nyx.entities.MeteorRenderer;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="nyx", value={Side.CLIENT})
public final class ClientEvents {
    private static String lastMoonTextures;

    @SubscribeEvent
    public static void onDebug(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74330_P) {
            return;
        }
        event.getLeft().add("");
        NyxWorld world = NyxWorld.get((World)mc.field_71441_e);
        String pre = TextFormatting.GREEN + "[" + "Nyx" + "]" + TextFormatting.RESET;
        String name = world.currentEvent == null ? "None" : world.currentEvent.name;
        event.getLeft().add(pre + " CurrEvent: " + name);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        String moonTex;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        NyxWorld nyx = NyxWorld.get((World)world);
        if (nyx == null) {
            return;
        }
        nyx.update();
        String string = moonTex = nyx.currentEvent != null ? nyx.currentEvent.getMoonTexture() : null;
        if (!Objects.equals(moonTex, lastMoonTextures)) {
            ResourceLocation newRes;
            lastMoonTextures = moonTex;
            RenderGlobal.field_110927_h = newRes = moonTex == null ? RenderGlobal.field_110927_h : new ResourceLocation("nyx", "textures/moon/" + moonTex + ".png");
        }
    }

    @SubscribeEvent
    public static void onFogRender(EntityViewRenderEvent.FogColors event) {
        if (!Config.moonEventTint) {
            return;
        }
        NyxWorld world = NyxWorld.get((World)Minecraft.func_71410_x().field_71441_e);
        if (world == null || world.currentSkyColor == 0) {
            return;
        }
        event.setRed(ClientEvents.lerp(event.getRed(), (float)(world.currentSkyColor >> 16 & 0xFF) / 255.0f, world.eventSkyModifier));
        event.setGreen(ClientEvents.lerp(event.getGreen(), (float)(world.currentSkyColor >> 8 & 0xFF) / 255.0f, world.eventSkyModifier));
        event.setBlue(ClientEvents.lerp(event.getBlue(), (float)(world.currentSkyColor & 0xFF) / 255.0f, world.eventSkyModifier));
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        if (Config.lunarWater) {
            ClientEvents.registerFluidRenderer(Registry.lunarWaterFluid);
            RenderingRegistry.registerEntityRenderingHandler(CauldronTracker.class, EmptyRenderer::new);
        }
        if (Config.fallingStars) {
            RenderingRegistry.registerEntityRenderingHandler(FallingStar.class, EmptyRenderer::new);
        }
        RenderingRegistry.registerEntityRenderingHandler(FallingMeteor.class, MeteorRenderer::new);
        for (Item item : Registry.MOD_ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void onColorRegistry(ColorHandlerEvent.Item event) {
        if (Config.meteors) {
            event.getItemColors().func_186730_a((stack, tintIndex) -> 13912595, new Item[]{Registry.meteorFinder});
        }
    }

    private static void registerFluidRenderer(Fluid fluid) {
        Block block = fluid.getBlock();
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    private static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    private static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        private final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.location = new ModelResourceLocation(new ResourceLocation("nyx", "fluids"), fluid.getName());
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return this.location;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.location;
        }
    }
}

