/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.entities;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FallingStar
extends Entity {
    protected float trajectoryX;
    protected float trajectoryY;
    protected float trajectoryZ;

    public FallingStar(World worldIn) {
        super(worldIn);
        this.func_174826_a(null);
        this.initTrajectory(1.0f);
    }

    public void func_70030_z() {
        this.customUpdate();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70091_d(MoverType.SELF, this.trajectoryX, this.trajectoryY, this.trajectoryZ);
        }
        super.func_70030_z();
    }

    protected void customUpdate() {
        block4: {
            block2: {
                block3: {
                    if (!this.isLoaded()) {
                        this.func_70106_y();
                        return;
                    }
                    if (this.field_70170_p.field_72995_K) break block2;
                    if (!this.field_70132_H) break block3;
                    this.func_184185_a(Registry.fallingStarImpactSound, (float)Config.fallingStarImpactVolume, 1.0f);
                    EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Registry.fallenStar));
                    item.getEntityData().func_74757_a("nyx:fallen_star", true);
                    this.field_70170_p.func_72838_d((Entity)item);
                    this.func_70106_y();
                    break block4;
                }
                if (this.field_70173_aa % 40 != 0) break block4;
                this.func_184185_a(Registry.fallingStarSound, (float)Config.fallingStarAmbientVolume, 1.0f);
                break block4;
            }
            for (int i = 0; i < 2; ++i) {
                double mX = -this.field_70159_w + this.field_70170_p.field_73012_v.nextGaussian() * 0.05;
                double mY = -this.field_70181_x + this.field_70170_p.field_73012_v.nextGaussian() * 0.05;
                double mZ = -this.field_70179_y + this.field_70170_p.field_73012_v.nextGaussian() * 0.05;
                this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, mX, mY, mZ, new int[0]);
            }
        }
    }

    protected boolean isLoaded() {
        return this.field_70170_p.func_175648_a(this.func_180425_c(), 34, false);
    }

    protected void initTrajectory(float multiplier) {
        this.trajectoryX = MathHelper.func_151240_a((Random)this.field_70170_p.field_73012_v, (float)0.5f, (float)1.25f) * multiplier;
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            this.trajectoryX *= -1.0f;
        }
        this.trajectoryY = MathHelper.func_151240_a((Random)this.field_70170_p.field_73012_v, (float)-0.5f, (float)-0.85f) * multiplier;
        this.trajectoryZ = MathHelper.func_151240_a((Random)this.field_70170_p.field_73012_v, (float)0.5f, (float)1.25f) * multiplier;
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            this.trajectoryZ *= -1.0f;
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.trajectoryX = compound.func_74760_g("trajectory_x");
        this.trajectoryY = compound.func_74760_g("trajectory_y");
        this.trajectoryZ = compound.func_74760_g("trajectory_z");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("trajectory_x", this.trajectoryX);
        compound.func_74776_a("trajectory_y", this.trajectoryY);
        compound.func_74776_a("trajectory_z", this.trajectoryZ);
    }
}

