/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.blocks;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.lunarevents.HarvestMoon;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Crystal
extends BlockContainer {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);

    public Crystal() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149715_a(0.9375f);
        this.func_149675_a(true);
        Registry.initBlock((Block)this, "crystal", ItemBlock::new);
        GameRegistry.registerTileEntity(TileEntityCrystal.class, (ResourceLocation)this.getRegistryName());
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState s, Random random) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityCrystal)) {
            return;
        }
        TileEntityCrystal crystal = (TileEntityCrystal)tile;
        if (crystal.durability <= 0) {
            return;
        }
        int range = 5;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos offset = pos.func_177982_a(x, y, z);
                    IBlockState state = worldIn.func_180495_p(offset);
                    Block block = state.func_177230_c();
                    if (!(block instanceof IGrowable) && !(block instanceof IPlantable)) continue;
                    for (int i = 0; i < 5; ++i) {
                        block.func_180645_a(worldIn, offset, state, random);
                    }
                    if (worldIn.func_180495_p(offset) == state) continue;
                    --crystal.durability;
                    if (crystal.durability > 0) continue;
                    return;
                }
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrystal();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public static class TileEntityCrystal
    extends TileEntity
    implements ITickable {
        public int durability;

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            compound.func_74768_a("durability", this.durability);
            return super.func_189515_b(compound);
        }

        public void func_145839_a(NBTTagCompound compound) {
            this.durability = compound.func_74762_e("durability");
            super.func_145839_a(compound);
        }

        public void func_73660_a() {
            NyxWorld data;
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 600L == 0L && (data = NyxWorld.get(this.field_145850_b)) != null && data.currentEvent instanceof HarvestMoon && this.field_145850_b.func_175678_i(this.field_174879_c.func_177984_a())) {
                this.durability = Math.min(Config.crystalDurability, this.durability + Config.crystalDurability / 10);
            }
        }
    }
}

