/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx;

import com.google.common.collect.Sets;
import de.ellpeck.nyx.Nyx;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemMetaHelper {
    public static Set<ItemStack> getFromString(String debugString, String s) {
        String[] itemData = s.split(":");
        if (itemData.length < 2 || itemData.length > 3) {
            Nyx.LOGGER.warn("Invalid {} '{}'", (Object)debugString, (Object)s);
            return Sets.newHashSet((Object[])new ItemStack[]{ItemStack.field_190927_a});
        }
        ResourceLocation r = new ResourceLocation(itemData[0], itemData[1]);
        if (!ForgeRegistries.ITEMS.containsKey(r)) {
            return Sets.newHashSet((Object[])new ItemStack[]{ItemStack.field_190927_a});
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(r);
        if (itemData.length == 3) {
            int meta = MathHelper.func_82715_a((String)itemData[2], (int)-1);
            if (meta < 0) {
                Nyx.LOGGER.warn("Invalid meta '{}' for {} '{}'", (Object)meta, (Object)debugString, (Object)s);
                return Sets.newHashSet((Object[])new ItemStack[]{ItemStack.field_190927_a});
            }
            return Sets.newHashSet((Object[])new ItemStack[]{new ItemStack(item, 1, meta)});
        }
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, subItems);
        return new HashSet<ItemStack>((Collection<ItemStack>)subItems);
    }

    public static Set<ItemStack> getFromStringArray(String debugString, String[] a) {
        return Arrays.stream(a).map(s -> ItemMetaHelper.getFromString(debugString, s)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<ItemStack> getFromStringCollection(String debugString, Collection<String> c) {
        return ItemMetaHelper.getFromStringArray(debugString, c.toArray(new String[0]));
    }
}

