/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.writers.raw;

import dev.xhyrom.brigo.shadow.tinylog.core.LogEntry;
import dev.xhyrom.brigo.shadow.tinylog.writers.raw.AbstractSocketWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Map;

public class UdpSocketWriter
extends AbstractSocketWriter {
    private DatagramSocket datagramSocket = new DatagramSocket();

    public UdpSocketWriter(Map<String, String> properties) throws IOException {
        super(properties);
    }

    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] message = this.formatMessage(logEntry);
        DatagramPacket packet = new DatagramPacket(message, message.length, this.getInetAddress(), this.getPort());
        this.datagramSocket.send(packet);
    }

    @Override
    public void flush() throws Exception {
    }

    @Override
    public void close() throws Exception {
        this.datagramSocket.close();
    }
}

