/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.writers.raw;

import dev.xhyrom.brigo.shadow.tinylog.Level;

public enum SyslogSeverity {
    EMERGENCY(0),
    ALERT(1),
    CRITICAL(2),
    ERROR(3),
    WARNING(4),
    NOTICE(5),
    INFORMATIONAL(6),
    DEBUG(7);

    private final int code;

    private SyslogSeverity(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SyslogSeverity getSeverity(Level level) {
        switch (level) {
            case TRACE: 
            case DEBUG: {
                return DEBUG;
            }
            case INFO: {
                return INFORMATIONAL;
            }
            case WARN: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
            case OFF: {
                return EMERGENCY;
            }
        }
        return INFORMATIONAL;
    }
}

