/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.writers.raw;

import dev.xhyrom.brigo.shadow.tinylog.writers.raw.ByteArrayWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class RandomAccessFileWriter
implements ByteArrayWriter {
    private final RandomAccessFile file;

    public RandomAccessFileWriter(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public int readTail(byte[] data, int offset, int length) throws IOException {
        long fileLength = this.file.length();
        this.file.seek(Math.max(0L, fileLength - (long)length));
        return this.file.read(data, offset, (int)Math.min(fileLength, (long)length));
    }

    @Override
    public void write(byte[] data, int length) throws IOException {
        this.write(data, 0, length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.file.write(data, offset, length);
    }

    @Override
    public void truncate(int count) throws IOException {
        this.file.setLength(Math.max(0L, this.file.length() - (long)count));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

