/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.writers.raw;

import dev.xhyrom.brigo.shadow.tinylog.writers.raw.ByteArrayWriter;
import java.io.IOException;

public final class BufferedWriterDecorator
implements ByteArrayWriter {
    private static final int BUFFER_CAPACITY = 65536;
    private final ByteArrayWriter writer;
    private final byte[] buffer;
    private int position;

    public BufferedWriterDecorator(ByteArrayWriter writer) {
        this.writer = writer;
        this.buffer = new byte[65536];
        this.position = 0;
    }

    @Override
    public int readTail(byte[] data, int offset, int length) throws IOException {
        if (length <= this.position) {
            System.arraycopy(this.buffer, this.position - length, data, offset, length);
            return length;
        }
        int readBytes = this.writer.readTail(data, offset, length - this.position);
        System.arraycopy(this.buffer, 0, data, offset + readBytes, this.position);
        return readBytes + this.position;
    }

    @Override
    public void write(byte[] data, int length) throws IOException {
        this.write(data, 0, length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.position > 0 && 65536 - this.position < length) {
            this.writer.write(this.buffer, 0, this.position);
            this.position = 0;
        }
        if (65536 < length) {
            this.writer.write(data, offset, length);
        } else {
            System.arraycopy(data, offset, this.buffer, this.position, length);
            this.position += length;
        }
    }

    @Override
    public void truncate(int count) throws IOException {
        if (count <= this.position) {
            this.position -= count;
        } else {
            this.writer.truncate(count - this.position);
            this.position = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            this.writer.write(this.buffer, 0, this.position);
            this.position = 0;
        }
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.position > 0) {
            this.writer.write(this.buffer, 0, this.position);
        }
        this.writer.close();
    }
}

