/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.writers;

import dev.xhyrom.brigo.shadow.tinylog.core.LogEntry;
import dev.xhyrom.brigo.shadow.tinylog.writers.AbstractFormatPatternWriter;
import dev.xhyrom.brigo.shadow.tinylog.writers.raw.AbstractSocketWriter;
import dev.xhyrom.brigo.shadow.tinylog.writers.raw.TcpSocketWriter;
import dev.xhyrom.brigo.shadow.tinylog.writers.raw.UdpSocketWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;

public final class SyslogWriter
extends AbstractFormatPatternWriter {
    private final AbstractSocketWriter socketWriter;

    public SyslogWriter(Map<String, String> properties) throws IllegalArgumentException, IOException {
        super(properties);
        String protocol = this.getStringValue("protocol");
        if (protocol == null || protocol.toUpperCase(Locale.ROOT).equals("UDP")) {
            this.socketWriter = new UdpSocketWriter(properties);
        } else if (protocol.toUpperCase(Locale.ROOT).equals("TCP")) {
            this.socketWriter = new TcpSocketWriter(properties);
        } else {
            throw new IllegalArgumentException("Invalid protocol");
        }
    }

    @Override
    public void write(LogEntry logEntry) throws Exception {
        this.socketWriter.write(logEntry);
    }

    @Override
    public void flush() throws Exception {
        this.socketWriter.flush();
    }

    @Override
    public void close() throws Exception {
        this.socketWriter.close();
    }
}

