/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.throwable;

import dev.xhyrom.brigo.shadow.tinylog.throwable.AbstractThrowableFilter;
import dev.xhyrom.brigo.shadow.tinylog.throwable.ThrowableData;
import dev.xhyrom.brigo.shadow.tinylog.throwable.ThrowableStore;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStackTraceElementsFilter
extends AbstractThrowableFilter {
    public AbstractStackTraceElementsFilter(String arguments) {
        super(arguments);
    }

    @Override
    public ThrowableData filter(ThrowableData origin) {
        List<StackTraceElement> currentTrace = origin.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>(currentTrace.size());
        for (StackTraceElement element : currentTrace) {
            if (!this.shouldKept(element.getClassName(), this.getArguments())) continue;
            newTrace.add(element);
        }
        ThrowableData cause = origin.getCause();
        if (cause != null) {
            cause = this.filter(cause);
        }
        return new ThrowableStore(origin.getClassName(), origin.getMessage(), newTrace, cause);
    }

    protected abstract boolean shouldKept(String var1, List<String> var2);

    protected boolean match(String className, String filter) {
        return className.startsWith(filter) && (filter.length() == className.length() || className.charAt(filter.length()) == '.');
    }
}

