/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.runtime;

import dev.xhyrom.brigo.shadow.tinylog.Level;
import dev.xhyrom.brigo.shadow.tinylog.provider.InternalLogger;
import dev.xhyrom.brigo.shadow.tinylog.runtime.AndroidRuntime;
import dev.xhyrom.brigo.shadow.tinylog.runtime.LegacyJavaRuntime;
import dev.xhyrom.brigo.shadow.tinylog.runtime.ModernJavaRuntime;
import dev.xhyrom.brigo.shadow.tinylog.runtime.RuntimeDialect;
import dev.xhyrom.brigo.shadow.tinylog.runtime.Timestamp;
import dev.xhyrom.brigo.shadow.tinylog.runtime.TimestampFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class RuntimeProvider {
    private static final int MINIMUM_VERSION_MODERN_JAVA = 9;
    private static final RuntimeDialect dialect = RuntimeProvider.resolveDialect();

    private RuntimeProvider() {
    }

    public static boolean isAndroid() {
        return dialect.isAndroid();
    }

    public static List<ClassLoader> getClassLoaders() {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classClassLoader = RuntimeProvider.class.getClassLoader();
        if (threadClassLoader == null || threadClassLoader == classClassLoader) {
            return Collections.singletonList(classClassLoader);
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(threadClassLoader);
        classLoaders.add(classClassLoader);
        return classLoaders;
    }

    public static String getDefaultWriter() {
        return dialect.getDefaultWriter();
    }

    public static long getProcessId() {
        return dialect.getProcessId();
    }

    public static Timestamp getStartTime() {
        return dialect.getStartTime();
    }

    public static String getCallerClassName(int depth) {
        return RuntimeProvider.stripAnonymousPart(dialect.getCallerClassName(depth + 1));
    }

    public static String getCallerClassName(String loggerClassName) {
        String callerClassName = dialect.getCallerClassName(loggerClassName);
        if (callerClassName == null) {
            InternalLogger.log(Level.ERROR, "Logger class \"" + loggerClassName + "\" is missing in stack trace");
            return "<unknown class>";
        }
        return RuntimeProvider.stripAnonymousPart(callerClassName);
    }

    public static StackTraceElement getCallerStackTraceElement(int depth) {
        return RuntimeProvider.normalizeClassName(dialect.getCallerStackTraceElement(depth + 1));
    }

    public static StackTraceElement getCallerStackTraceElement(String loggerClassName) {
        StackTraceElement element = dialect.getCallerStackTraceElement(loggerClassName);
        if (element == null) {
            InternalLogger.log(Level.ERROR, "Logger class \"" + loggerClassName + "\" is missing in stack trace");
            return new StackTraceElement("<unknown class>", "<unknown method>", "<unknown file>", -1);
        }
        return RuntimeProvider.normalizeClassName(element);
    }

    public static Timestamp createTimestamp() {
        return dialect.createTimestamp();
    }

    public static TimestampFormatter createTimestampFormatter(String pattern, Locale locale) {
        return dialect.createTimestampFormatter(pattern, locale);
    }

    private static RuntimeDialect resolveDialect() {
        if (RuntimeProvider.getJavaVersion() >= 9) {
            return new ModernJavaRuntime();
        }
        if ("Android Runtime".equalsIgnoreCase(System.getProperty("java.runtime.name"))) {
            return new AndroidRuntime();
        }
        return new LegacyJavaRuntime();
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version == null) {
            return -1;
        }
        int index = version.indexOf(46);
        if (index > 0) {
            version = version.substring(0, index);
        }
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static String stripAnonymousPart(String className) {
        int index = className.indexOf("$", 0);
        while (index != -1) {
            if (index >= className.length() - 1) {
                return className.substring(0, index);
            }
            char firstLetter = className.charAt(index + 1);
            if (firstLetter < 'A' || firstLetter > 'Z') {
                return className.substring(0, index);
            }
            index = className.indexOf(36, index + 2);
        }
        return className;
    }

    private static StackTraceElement normalizeClassName(StackTraceElement element) {
        String className = element.getClassName();
        int dollarIndex = className.indexOf("$");
        if (dollarIndex == -1) {
            return element;
        }
        className = RuntimeProvider.stripAnonymousPart(className);
        return new StackTraceElement(className, element.getMethodName(), element.getFileName(), element.getLineNumber());
    }
}

