/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.runtime;

import dev.xhyrom.brigo.shadow.tinylog.Level;
import dev.xhyrom.brigo.shadow.tinylog.provider.InternalLogger;
import dev.xhyrom.brigo.shadow.tinylog.runtime.AbstractJavaRuntime;
import dev.xhyrom.brigo.shadow.tinylog.runtime.LegacyTimestamp;
import dev.xhyrom.brigo.shadow.tinylog.runtime.LegacyTimestampFormatter;
import dev.xhyrom.brigo.shadow.tinylog.runtime.Timestamp;
import dev.xhyrom.brigo.shadow.tinylog.runtime.TimestampFormatter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import sun.reflect.Reflection;

public final class LegacyJavaRuntime
extends AbstractJavaRuntime {
    private static final Timestamp startTime = new LegacyTimestamp(ManagementFactory.getRuntimeMXBean().getStartTime());
    private final boolean hasSunReflection = LegacyJavaRuntime.verifySunReflection();
    private final Method stackTraceElementGetter = LegacyJavaRuntime.getStackTraceElementGetter();

    @Override
    public boolean isAndroid() {
        return false;
    }

    @Override
    public long getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.parseLong(name.substring(0, name.indexOf(64)));
        }
        catch (NumberFormatException ex) {
            InternalLogger.log(Level.ERROR, "Illegal process ID: " + name.substring(0, name.indexOf(64)));
            return -1L;
        }
        catch (IndexOutOfBoundsException ex) {
            InternalLogger.log(Level.ERROR, "Name of virtual machine does not contain a process ID: " + name);
            return -1L;
        }
    }

    @Override
    public Timestamp getStartTime() {
        return startTime;
    }

    @Override
    @IgnoreJRERequirement
    public String getCallerClassName(int depth) {
        if (this.hasSunReflection) {
            return Reflection.getCallerClass((int)(depth + 1)).getName();
        }
        return this.getCallerStackTraceElement(depth + 1).getClassName();
    }

    @Override
    public String getCallerClassName(String loggerClassName) {
        StackTraceElement element = this.getCallerStackTraceElement(loggerClassName);
        return element == null ? null : element.getClassName();
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(int depth) {
        if (this.stackTraceElementGetter != null) {
            try {
                return (StackTraceElement)this.stackTraceElementGetter.invoke((Object)new Throwable(), depth);
            }
            catch (IllegalAccessException ex) {
                InternalLogger.log(Level.ERROR, ex, "Failed getting single stack trace element from throwable");
            }
            catch (InvocationTargetException ex) {
                InternalLogger.log(Level.ERROR, ex.getTargetException(), "Failed getting single stack trace element from throwable");
            }
        }
        return new Throwable().getStackTrace()[depth];
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(String loggerClassName) {
        int index;
        StackTraceElement[] trace = new Throwable().getStackTrace();
        for (index = 0; index < trace.length && !loggerClassName.equals(trace[index].getClassName()); ++index) {
        }
        while (index < trace.length && loggerClassName.equals(trace[index].getClassName())) {
            ++index;
        }
        if (index < trace.length) {
            return trace[index];
        }
        return null;
    }

    @Override
    public Timestamp createTimestamp() {
        return new LegacyTimestamp();
    }

    @Override
    public TimestampFormatter createTimestampFormatter(String pattern, Locale locale) {
        return new LegacyTimestampFormatter(pattern, locale);
    }

    @IgnoreJRERequirement
    private static boolean verifySunReflection() {
        try {
            return AbstractJavaRuntime.class.equals((Object)Reflection.getCallerClass((int)1));
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
        catch (NoSuchMethodError error) {
            return false;
        }
        catch (UnsatisfiedLinkError error) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static Method getStackTraceElementGetter() {
        try {
            Method method = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            method.setAccessible(true);
            StackTraceElement stackTraceElement = (StackTraceElement)method.invoke((Object)new Throwable(), 0);
            if (LegacyJavaRuntime.class.getName().equals(stackTraceElement.getClassName())) {
                return method;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

