/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.pattern;

import dev.xhyrom.brigo.shadow.tinylog.core.LogEntry;
import dev.xhyrom.brigo.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.brigo.shadow.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class TimestampToken
implements Token {
    private static final long SECONDS_DIVISOR = 1000L;
    private final boolean useMilliseconds;

    TimestampToken() {
        this.useMilliseconds = false;
    }

    TimestampToken(String unit) {
        this.useMilliseconds = "milliseconds".equals(unit);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singletonList(LogEntryValue.DATE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        builder.append(this.getTime(logEntry));
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setLong(index, this.getTime(logEntry));
    }

    private long getTime(LogEntry logEntry) {
        long timestamp = logEntry.getTimestamp().toDate().getTime();
        return this.useMilliseconds ? timestamp : timestamp / 1000L;
    }
}

