/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.pattern;

import dev.xhyrom.brigo.shadow.tinylog.core.LogEntry;
import dev.xhyrom.brigo.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.brigo.shadow.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class ThreadContextToken
implements Token {
    private static final String DEFAULT_EMPTY_VALUE = "";
    private final String key;
    private final String defaultValue;

    ThreadContextToken(String key) {
        this.key = key;
        this.defaultValue = DEFAULT_EMPTY_VALUE;
    }

    ThreadContextToken(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singletonList(LogEntryValue.CONTEXT);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        String value = logEntry.getContext().get(this.key);
        if (value == null) {
            builder.append(this.defaultValue);
        } else {
            builder.append(value);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        String value = logEntry.getContext().get(this.key);
        if (value == null && !DEFAULT_EMPTY_VALUE.equals(this.defaultValue)) {
            statement.setString(index, this.defaultValue);
        } else {
            statement.setString(index, value);
        }
    }
}

