/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.path;

import dev.xhyrom.brigo.shadow.tinylog.path.Segment;
import dev.xhyrom.brigo.shadow.tinylog.runtime.Timestamp;
import java.io.File;

final class CountSegment
implements Segment {
    CountSegment() {
    }

    @Override
    public String getStaticText() {
        return null;
    }

    @Override
    public String createToken(String prefix, Timestamp timestamp) {
        String[] entries;
        String filePrefix;
        File directory;
        int separator = Math.max(prefix.lastIndexOf(File.separatorChar), prefix.lastIndexOf(47));
        if (separator == -1) {
            directory = new File("").getAbsoluteFile();
            filePrefix = prefix;
        } else {
            directory = new File(prefix.substring(0, separator));
            filePrefix = separator == prefix.length() - 1 ? "" : prefix.substring(separator + 1);
        }
        long count = 0L;
        if (directory.isDirectory() && (entries = directory.list()) != null) {
            for (String entry : entries) {
                Long foundCount;
                if (!entry.startsWith(filePrefix) || (foundCount = CountSegment.parseDigits(entry, filePrefix.length())) == null || foundCount + 1L <= count) continue;
                count = foundCount + 1L;
            }
        }
        return Long.toString(count);
    }

    @Override
    public boolean validateToken(String token) {
        try {
            Long.parseLong(token);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static Long parseDigits(String text, int start) {
        for (int i = start; i < text.length(); ++i) {
            char character = text.charAt(i);
            if (character >= '0' && character <= '9') continue;
            return CountSegment.parseLong(text.substring(start, i));
        }
        return CountSegment.parseLong(text.substring(start));
    }

    private static Long parseLong(String text) {
        if (text.length() == 0) {
            return null;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

