/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.configuration;

import dev.xhyrom.brigo.shadow.tinylog.Level;
import dev.xhyrom.brigo.shadow.tinylog.configuration.ConfigurationLoader;
import dev.xhyrom.brigo.shadow.tinylog.provider.InternalLogger;
import dev.xhyrom.brigo.shadow.tinylog.runtime.RuntimeProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Pattern;

public class PropertiesConfigurationLoader
implements ConfigurationLoader {
    private static final String[] CONFIGURATION_FILES = new String[]{"tinylog-dev.properties", "tinylog-test.properties", "tinylog.properties"};
    private static final String CONFIGURATION_PROPERTY = "tinylog.configuration";
    private static final Pattern URL_DETECTION_PATTERN = Pattern.compile("^[a-zA-Z]{2,}:/.*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties load() {
        Properties properties;
        block17: {
            properties = new Properties();
            String file = System.getProperty(CONFIGURATION_PROPERTY);
            InputStream stream = null;
            try {
                if (file != null) {
                    if (URL_DETECTION_PATTERN.matcher(file).matches()) {
                        stream = new URL(file).openStream();
                    } else {
                        stream = this.getClasspathStream(file);
                        if (stream == null) {
                            stream = new FileInputStream(file);
                        }
                    }
                    this.load(properties, stream);
                    break block17;
                }
                for (String configurationFile : this.getConfigurationFiles()) {
                    file = configurationFile;
                    stream = this.getClasspathStream(file);
                    if (stream == null) continue;
                    this.load(properties, stream);
                    break;
                }
            }
            catch (IOException ex) {
                InternalLogger.log(Level.ERROR, "Failed loading configuration from '" + file + "'");
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    protected void load(Properties properties, InputStream stream) throws IOException {
        properties.load(stream);
    }

    protected String[] getConfigurationFiles() {
        return CONFIGURATION_FILES;
    }

    private InputStream getClasspathStream(String fileName) {
        for (ClassLoader loader : RuntimeProvider.getClassLoaders()) {
            InputStream stream = loader.getResourceAsStream(fileName);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }
}

