/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.brigadier.arguments;

import dev.xhyrom.brigo.shadow.brigadier.StringReader;
import dev.xhyrom.brigo.shadow.brigadier.arguments.ArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.context.CommandContext;
import dev.xhyrom.brigo.shadow.brigadier.exceptions.CommandSyntaxException;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestions;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class BoolArgumentType
implements ArgumentType<Boolean> {
    private static final Collection<String> EXAMPLES = Arrays.asList("true", "false");

    private BoolArgumentType() {
    }

    public static BoolArgumentType bool() {
        return new BoolArgumentType();
    }

    public static boolean getBool(CommandContext<?> context, String name) {
        return context.getArgument(name, Boolean.class);
    }

    @Override
    public Boolean parse(StringReader reader) throws CommandSyntaxException {
        return reader.readBoolean();
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if ("true".startsWith(builder.getRemainingLowerCase())) {
            builder.suggest("true");
        }
        if ("false".startsWith(builder.getRemainingLowerCase())) {
            builder.suggest("false");
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

