/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.mixin.server;

import com.google.common.collect.Maps;
import dev.xhyrom.brigo.accessor.CommandHandlerExtras;
import dev.xhyrom.brigo.client.ISuggestionProvider;
import dev.xhyrom.brigo.client.network.CommandsPacket;
import dev.xhyrom.brigo.command.CommandSource;
import dev.xhyrom.brigo.command.CommandTreeConverter;
import dev.xhyrom.brigo.compat.CompatRegistry;
import dev.xhyrom.brigo.shadow.brigadier.CommandDispatcher;
import dev.xhyrom.brigo.shadow.brigadier.arguments.StringArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.builder.LiteralArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.builder.RequiredArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.tree.CommandNode;
import dev.xhyrom.brigo.shadow.brigadier.tree.RootCommandNode;
import java.util.HashMap;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CommandHandler.class})
public class CommandHandlerMixin
implements CommandHandlerExtras {
    @Unique
    private final CommandDispatcher<CommandSource> brigo$dispatcher = new CommandDispatcher();

    @Inject(method={"registerCommand"}, at={@At(value="HEAD")})
    private void onRegisterCommand(ICommand command, CallbackInfoReturnable<ICommand> cir) {
        this.brigo$registerBrigoCommand(command);
    }

    @Unique
    private void brigo$registerBrigoCommand(ICommand command) {
        CommandNode node = CompatRegistry.hasCompatFor(command.getClass()) ? CompatRegistry.getCompatCommand(command.getClass()) : ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(command.func_71517_b()).then(this.brigo$createParameterArgument())).build();
        this.brigo$dispatcher.getRoot().addChild(node);
        command.func_71514_a().forEach(alias -> {
            if (alias.equals(command.func_71517_b())) {
                return;
            }
            this.brigo$dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(alias).redirect(node));
        });
    }

    @Unique
    private RequiredArgumentBuilder<CommandSource, String> brigo$createParameterArgument() {
        return RequiredArgumentBuilder.argument("params", StringArgumentType.greedyString()).suggests((context, suggestions) -> suggestions.buildFuture());
    }

    @Override
    @Unique
    public void brigo$sendCommands(@NotNull EntityPlayerMP player) {
        CommandSource source = CommandSource.adapt((ICommandSender)player);
        RootCommandNode<ISuggestionProvider> clientRoot = this.brigo$buildClientCommandTree(source);
        player.field_71135_a.func_147359_a((Packet)CommandsPacket.create(clientRoot));
    }

    @Unique
    private RootCommandNode<ISuggestionProvider> brigo$buildClientCommandTree(CommandSource source) {
        HashMap nodeMapping = Maps.newHashMap();
        RootCommandNode<ISuggestionProvider> clientRoot = new RootCommandNode<ISuggestionProvider>();
        nodeMapping.put(this.brigo$dispatcher.getRoot(), clientRoot);
        new CommandTreeConverter(nodeMapping, source).convertChildren(this.brigo$dispatcher.getRoot(), clientRoot);
        return clientRoot;
    }

    @Override
    @Unique
    public CommandDispatcher<CommandSource> brigo$dispatcher() {
        return this.brigo$dispatcher;
    }
}

