/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.mixin.client;

import dev.xhyrom.brigo.accessor.NetHandlerPlayClientExtras;
import dev.xhyrom.brigo.client.ClientSuggestionProvider;
import dev.xhyrom.brigo.client.ISuggestionProvider;
import dev.xhyrom.brigo.client.network.CommandsPacket;
import dev.xhyrom.brigo.shadow.brigadier.CommandDispatcher;
import dev.xhyrom.brigo.shadow.brigadier.arguments.StringArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.builder.LiteralArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.builder.RequiredArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.context.StringRange;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestion;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestions;
import dev.xhyrom.brigo.util.SuggestionProviders;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketTabComplete;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetHandlerPlayClient.class})
public class NetHandlerPlayClientMixin
implements NetHandlerPlayClientExtras {
    @Shadow
    private Minecraft field_147299_f;
    @Unique
    private ClientSuggestionProvider brigo$suggestionsProvider;
    @Unique
    private CommandDispatcher<ISuggestionProvider> brigo$commands = new CommandDispatcher();
    @Unique
    private boolean brigo$entityStatusReceived = false;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.brigo$suggestionsProvider = new ClientSuggestionProvider((NetHandlerPlayClient)this, this.field_147299_f);
    }

    @Inject(method={"handleTabComplete"}, at={@At(value="TAIL")})
    private void handleTabComplete(SPacketTabComplete packetIn, CallbackInfo ci) {
        String command = ClientSuggestionProvider.command;
        String[] matches = packetIn.func_149630_c();
        int lastSpace = command.lastIndexOf(32);
        int replaceStart = lastSpace == -1 ? 0 : lastSpace + 1;
        int replaceEnd = command.length();
        StringRange replacementRange = StringRange.between(replaceStart, replaceEnd);
        List<Suggestion> suggestions = Arrays.stream(matches).map(match -> new Suggestion(replacementRange, (String)match)).collect(Collectors.toList());
        this.brigo$suggestionsProvider.completeCustomSuggestions(new Suggestions(replacementRange, suggestions));
    }

    @Inject(method={"handleCustomPayload"}, at={@At(value="TAIL")})
    private void handleCustomPayload(SPacketCustomPayload packetIn, CallbackInfo ci) {
        if (!packetIn.func_149169_c().equals("brigo:commands")) {
            return;
        }
        this.brigo$commands = new CommandDispatcher<ISuggestionProvider>(CommandsPacket.read(packetIn.func_180735_b()));
    }

    @Inject(method={"handleEntityStatus"}, at={@At(value="TAIL")})
    private void handleEntityStatus(SPacketEntityStatus packetIn, CallbackInfo ci) {
        if (!this.brigo$commands.getRoot().getChildren().isEmpty() || this.brigo$entityStatusReceived) {
            return;
        }
        this.brigo$entityStatusReceived = true;
        this.brigo$suggestionsProvider().getSuggestionsFromServer().thenAccept(commands -> {
            for (Suggestion suggestion : commands.getList()) {
                this.brigo$commands.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(suggestion.getText().substring(1)).then(RequiredArgumentBuilder.argument("params", StringArgumentType.greedyString()).suggests(SuggestionProviders.ASK_SERVER)));
            }
        });
    }

    @Override
    @Unique
    public ClientSuggestionProvider brigo$suggestionsProvider() {
        return this.brigo$suggestionsProvider;
    }

    @Override
    @Unique
    @NotNull
    public CommandDispatcher<ISuggestionProvider> brigo$commands() {
        return this.brigo$commands;
    }
}

