/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.command.serialization.serializers;

import dev.xhyrom.brigo.command.serialization.ArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.BrigadierArgumentSerializers;
import dev.xhyrom.brigo.shadow.brigadier.arguments.IntegerArgumentType;
import net.minecraft.network.PacketBuffer;

public class IntegerArgumentSerializer
implements ArgumentSerializer<IntegerArgumentType> {
    @Override
    public void serializeToNetwork(IntegerArgumentType pArgument, PacketBuffer pBuffer) {
        boolean flag = pArgument.getMinimum() != Integer.MIN_VALUE;
        boolean flag1 = pArgument.getMaximum() != Integer.MAX_VALUE;
        pBuffer.writeByte((int)BrigadierArgumentSerializers.createNumberFlags(flag, flag1));
        if (flag) {
            pBuffer.writeInt(pArgument.getMinimum());
        }
        if (flag1) {
            pBuffer.writeInt(pArgument.getMaximum());
        }
    }

    @Override
    public IntegerArgumentType deserializeFromNetwork(PacketBuffer pBuffer) {
        byte b0 = pBuffer.readByte();
        int i = BrigadierArgumentSerializers.numberHasMin(b0) ? pBuffer.readInt() : Integer.MIN_VALUE;
        int j = BrigadierArgumentSerializers.numberHasMax(b0) ? pBuffer.readInt() : Integer.MAX_VALUE;
        return IntegerArgumentType.integer(i, j);
    }
}

