/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.command.serialization.serializers;

import dev.xhyrom.brigo.command.serialization.ArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.BrigadierArgumentSerializers;
import dev.xhyrom.brigo.shadow.brigadier.arguments.FloatArgumentType;
import net.minecraft.network.PacketBuffer;

public class FloatArgumentSerializer
implements ArgumentSerializer<FloatArgumentType> {
    @Override
    public void serializeToNetwork(FloatArgumentType pArgument, PacketBuffer pBuffer) {
        boolean flag = pArgument.getMinimum() != -3.4028235E38f;
        boolean flag1 = pArgument.getMaximum() != Float.MAX_VALUE;
        pBuffer.writeByte((int)BrigadierArgumentSerializers.createNumberFlags(flag, flag1));
        if (flag) {
            pBuffer.writeFloat(pArgument.getMinimum());
        }
        if (flag1) {
            pBuffer.writeFloat(pArgument.getMaximum());
        }
    }

    @Override
    public FloatArgumentType deserializeFromNetwork(PacketBuffer pBuffer) {
        byte b0 = pBuffer.readByte();
        float f = BrigadierArgumentSerializers.numberHasMin(b0) ? pBuffer.readFloat() : -3.4028235E38f;
        float f1 = BrigadierArgumentSerializers.numberHasMax(b0) ? pBuffer.readFloat() : Float.MAX_VALUE;
        return FloatArgumentType.floatArg(f, f1);
    }
}

