/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.client.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import dev.xhyrom.brigo.client.ISuggestionProvider;
import dev.xhyrom.brigo.command.serialization.ArgumentTypes;
import dev.xhyrom.brigo.shadow.brigadier.arguments.ArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.builder.ArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.builder.LiteralArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.builder.RequiredArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.tree.ArgumentCommandNode;
import dev.xhyrom.brigo.shadow.brigadier.tree.CommandNode;
import dev.xhyrom.brigo.shadow.brigadier.tree.LiteralCommandNode;
import dev.xhyrom.brigo.shadow.brigadier.tree.RootCommandNode;
import dev.xhyrom.brigo.util.SuggestionProviders;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import org.jetbrains.annotations.Nullable;

public class CommandsPacket {
    public static final String COMMANDS_CHANNEL = "brigo:commands";
    private static final byte NODE_TYPE_ROOT = 0;
    private static final byte NODE_TYPE_LITERAL = 1;
    private static final byte NODE_TYPE_ARGUMENT = 2;
    private static final byte FLAG_HAS_REDIRECT = 8;
    private static final byte FLAG_HAS_COMMAND = 4;
    private static final byte FLAG_HAS_SUGGESTIONS = 16;

    public static SPacketCustomPayload create(RootCommandNode<ISuggestionProvider> root) {
        return new PacketBuilder().withRoot(root).build();
    }

    public static RootCommandNode<ISuggestionProvider> read(PacketBuffer buffer) {
        return new PacketReader(buffer).readCommands();
    }

    private static Object2IntMap<CommandNode<ISuggestionProvider>> enumerateNodesRecursively(RootCommandNode<ISuggestionProvider> root) {
        CommandNode current;
        Object2IntOpenHashMap nodeMap = new Object2IntOpenHashMap();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(root);
        while ((current = (CommandNode)queue.poll()) != null) {
            if (nodeMap.containsKey((Object)current)) continue;
            nodeMap.put((Object)current, nodeMap.size());
            queue.addAll(current.getChildren());
            if (current.getRedirect() == null) continue;
            queue.add(current.getRedirect());
        }
        return nodeMap;
    }

    private static List<CommandNode<ISuggestionProvider>> getNodesInIdOrder(Object2IntMap<CommandNode<ISuggestionProvider>> nodeMap) {
        CommandNode[] nodes = new CommandNode[nodeMap.size()];
        nodeMap.object2IntEntrySet().forEach(entry -> {
            nodes[entry.getIntValue()] = (CommandNode)entry.getKey();
        });
        return Arrays.asList(nodes);
    }

    private static <T> void writeCollection(PacketBuffer buffer, Collection<T> collection, BiConsumer<PacketBuffer, T> writer) {
        buffer.func_150787_b(collection.size());
        collection.forEach(item -> writer.accept(buffer, item));
    }

    private static class NodeEntry {
        @Nullable
        private final ArgumentBuilder<ISuggestionProvider, ?> builder;
        private final byte flags;
        private final int redirectIndex;
        private final int[] childIndices;
        @Nullable
        private CommandNode<ISuggestionProvider> node;

        NodeEntry(@Nullable ArgumentBuilder<ISuggestionProvider, ?> builder, byte flags, int redirectIndex, int[] childIndices) {
            this.builder = builder;
            this.flags = flags;
            this.redirectIndex = redirectIndex;
            this.childIndices = childIndices;
        }

        boolean tryBuild(List<NodeEntry> allEntries) {
            if (this.node != null) {
                return true;
            }
            if (this.redirectIndex >= 0 && allEntries.get((int)this.redirectIndex).node == null) {
                return false;
            }
            for (int childIndex : this.childIndices) {
                if (allEntries.get((int)childIndex).node != null) continue;
                return false;
            }
            if (this.redirectIndex >= 0 && this.builder != null) {
                this.builder.redirect(allEntries.get((int)this.redirectIndex).node);
            }
            if (this.builder == null) {
                this.node = new RootCommandNode<ISuggestionProvider>();
            } else {
                if ((this.flags & 4) != 0) {
                    this.builder.executes(context -> 0);
                }
                this.node = this.builder.build();
            }
            for (int childIndex : this.childIndices) {
                CommandNode<ISuggestionProvider> childNode = allEntries.get((int)childIndex).node;
                if (childNode instanceof RootCommandNode) continue;
                this.node.addChild(childNode);
            }
            return true;
        }

        CommandNode<ISuggestionProvider> getNode() {
            return this.node;
        }
    }

    private static class PacketReader {
        private final PacketBuffer buffer;
        private final List<NodeEntry> entries = Lists.newArrayList();
        private int rootIndex;

        public PacketReader(PacketBuffer buffer) {
            this.buffer = buffer;
        }

        public RootCommandNode<ISuggestionProvider> readCommands() {
            return this.readEntries().readRootIndex().resolveNodes().getRootNode();
        }

        private PacketReader readEntries() {
            int entryCount = this.buffer.func_150792_a();
            for (int i = 0; i < entryCount; ++i) {
                this.entries.add(this.readNodeEntry());
            }
            return this;
        }

        private PacketReader readRootIndex() {
            this.rootIndex = this.buffer.func_150792_a();
            return this;
        }

        private PacketReader resolveNodes() {
            ArrayList unresolved = Lists.newArrayList(this.entries);
            while (!unresolved.isEmpty()) {
                boolean progress = unresolved.removeIf(entry -> entry.tryBuild(this.entries));
                if (progress) continue;
                throw new IllegalStateException("Server sent an impossible command tree");
            }
            return this;
        }

        private RootCommandNode<ISuggestionProvider> getRootNode() {
            return (RootCommandNode)this.entries.get(this.rootIndex).getNode();
        }

        private NodeEntry readNodeEntry() {
            byte flags = this.buffer.readByte();
            int[] childIndices = this.buffer.func_186863_b();
            int redirectIndex = (flags & 8) != 0 ? this.buffer.func_150792_a() : -1;
            ArgumentBuilder<ISuggestionProvider, ?> builder = this.createBuilder(flags);
            return new NodeEntry(builder, flags, redirectIndex, childIndices);
        }

        @Nullable
        private ArgumentBuilder<ISuggestionProvider, ?> createBuilder(byte flags) {
            int nodeType = flags & 3;
            switch (nodeType) {
                case 1: {
                    return LiteralArgumentBuilder.literal(this.buffer.func_150789_c(Short.MAX_VALUE));
                }
                case 2: {
                    return this.createArgumentBuilder(flags);
                }
            }
            return null;
        }

        @Nullable
        private RequiredArgumentBuilder<ISuggestionProvider, ?> createArgumentBuilder(byte flags) {
            String name = this.buffer.func_150789_c(Short.MAX_VALUE);
            ArgumentType<?> argumentType = ArgumentTypes.deserialize(this.buffer);
            if (argumentType == null) {
                return null;
            }
            RequiredArgumentBuilder<ISuggestionProvider, ?> builder = RequiredArgumentBuilder.argument(name, argumentType);
            if ((flags & 0x10) != 0) {
                builder.suggests(SuggestionProviders.get(this.buffer.func_192575_l()));
            }
            return builder;
        }
    }

    private static class PacketBuilder {
        private RootCommandNode<ISuggestionProvider> root;
        private final Map<CommandNode<ISuggestionProvider>, Integer> nodeIdMap = Maps.newHashMap();
        private final List<CommandNode<ISuggestionProvider>> nodeList = Lists.newArrayList();

        private PacketBuilder() {
        }

        public PacketBuilder withRoot(RootCommandNode<ISuggestionProvider> root) {
            this.root = root;
            return this;
        }

        public SPacketCustomPayload build() {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            this.enumerateNodes().writeNodes(buffer).writeRootIndex(buffer);
            return new SPacketCustomPayload(CommandsPacket.COMMANDS_CHANNEL, buffer);
        }

        private PacketBuilder enumerateNodes() {
            Object2IntMap enumeration = CommandsPacket.enumerateNodesRecursively(this.root);
            this.nodeIdMap.putAll((Map<CommandNode<ISuggestionProvider>, Integer>)enumeration);
            this.nodeList.addAll(CommandsPacket.getNodesInIdOrder((Object2IntMap<CommandNode<ISuggestionProvider>>)enumeration));
            return this;
        }

        private PacketBuilder writeNodes(PacketBuffer buffer) {
            CommandsPacket.writeCollection(buffer, this.nodeList, this::writeNode);
            return this;
        }

        private PacketBuilder writeRootIndex(PacketBuffer buffer) {
            buffer.func_150787_b(this.nodeIdMap.get(this.root).intValue());
            return this;
        }

        private void writeNode(PacketBuffer buffer, CommandNode<ISuggestionProvider> node) {
            byte flags = this.calculateNodeFlags(node);
            buffer.writeByte((int)flags);
            this.writeChildrenIds(buffer, node);
            this.writeRedirectId(buffer, node);
            this.writeNodeData(buffer, node);
        }

        private byte calculateNodeFlags(CommandNode<ISuggestionProvider> node) {
            byte flags = this.getNodeType(node);
            if (node.getRedirect() != null) {
                flags = (byte)(flags | 8);
            }
            if (node.getCommand() != null) {
                flags = (byte)(flags | 4);
            }
            if (node instanceof ArgumentCommandNode && ((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                flags = (byte)(flags | 0x10);
            }
            return flags;
        }

        private byte getNodeType(CommandNode<ISuggestionProvider> node) {
            if (node instanceof RootCommandNode) {
                return 0;
            }
            if (node instanceof LiteralCommandNode) {
                return 1;
            }
            if (node instanceof ArgumentCommandNode) {
                return 2;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node.getClass());
        }

        private void writeChildrenIds(PacketBuffer buffer, CommandNode<ISuggestionProvider> node) {
            buffer.func_150787_b(node.getChildren().size());
            for (CommandNode<ISuggestionProvider> child : node.getChildren()) {
                buffer.func_150787_b(this.nodeIdMap.get(child).intValue());
            }
        }

        private void writeRedirectId(PacketBuffer buffer, CommandNode<ISuggestionProvider> node) {
            if (node.getRedirect() != null) {
                buffer.func_150787_b(this.nodeIdMap.get(node.getRedirect()).intValue());
            }
        }

        private void writeNodeData(PacketBuffer buffer, CommandNode<ISuggestionProvider> node) {
            if (node instanceof ArgumentCommandNode) {
                this.writeArgumentNode(buffer, (ArgumentCommandNode)node);
            } else if (node instanceof LiteralCommandNode) {
                this.writeLiteralNode(buffer, (LiteralCommandNode)node);
            }
        }

        private void writeArgumentNode(PacketBuffer buffer, ArgumentCommandNode<ISuggestionProvider, ?> node) {
            buffer.func_180714_a(node.getName());
            ArgumentTypes.serialize(buffer, node.getType());
            if (node.getCustomSuggestions() != null) {
                buffer.func_192572_a(SuggestionProviders.getId(node.getCustomSuggestions()));
            }
        }

        private void writeLiteralNode(PacketBuffer buffer, LiteralCommandNode<ISuggestionProvider> node) {
            buffer.func_180714_a(node.getLiteral());
        }
    }
}

