/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import dev.xhyrom.brigo.accessor.GuiTextFieldExtras;
import dev.xhyrom.brigo.accessor.NetHandlerPlayClientExtras;
import dev.xhyrom.brigo.client.ClientSuggestionProvider;
import dev.xhyrom.brigo.client.ISuggestionProvider;
import dev.xhyrom.brigo.client.renderer.Rect2i;
import dev.xhyrom.brigo.shadow.brigadier.CommandDispatcher;
import dev.xhyrom.brigo.shadow.brigadier.Message;
import dev.xhyrom.brigo.shadow.brigadier.ParseResults;
import dev.xhyrom.brigo.shadow.brigadier.StringReader;
import dev.xhyrom.brigo.shadow.brigadier.context.CommandContextBuilder;
import dev.xhyrom.brigo.shadow.brigadier.context.ParsedArgument;
import dev.xhyrom.brigo.shadow.brigadier.context.SuggestionContext;
import dev.xhyrom.brigo.shadow.brigadier.exceptions.CommandSyntaxException;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestion;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestions;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.SuggestionsBuilder;
import dev.xhyrom.brigo.shadow.brigadier.tree.CommandNode;
import dev.xhyrom.brigo.shadow.brigadier.tree.LiteralCommandNode;
import dev.xhyrom.brigo.util.ComponentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;

public class CommandSuggestions {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final TextFormatting[] ARGUMENT_COLORS = new TextFormatting[]{TextFormatting.AQUA, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD};
    private final Minecraft minecraft;
    private final GuiScreen screen;
    private final GuiTextField input;
    private final FontRenderer fontRenderer;
    private final CommandSuggestionsConfig config;
    private final List<String> commandUsage = Lists.newArrayList();
    private int commandUsagePosition;
    private int commandUsageWidth;
    private boolean allowSuggestions;
    private boolean keepSuggestions;
    @Nullable
    private ParseResults<ISuggestionProvider> currentParse;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestions;
    @Nullable
    private SuggestionsList suggestions;

    public CommandSuggestions(Minecraft minecraft, GuiScreen screen, GuiTextField input, FontRenderer fontRenderer, CommandSuggestionsConfig config) {
        this.minecraft = minecraft;
        this.screen = screen;
        this.input = input;
        this.fontRenderer = fontRenderer;
        this.config = config;
        ((GuiTextFieldExtras)input).brigo$textFormatter(this::formatCommandText);
    }

    public void allowSuggestions(boolean allow) {
        this.allowSuggestions = allow;
        if (!allow) {
            this.suggestions = null;
        }
    }

    public boolean handleKeyPress(int keyCode) {
        if (this.suggestions != null && this.suggestions.handleKeyPress(keyCode)) {
            return true;
        }
        if (keyCode == 15) {
            this.showSuggestions();
            return true;
        }
        return false;
    }

    public boolean handleMouseScroll(double delta) {
        return this.suggestions != null && this.suggestions.handleMouseScroll(MathHelper.func_151237_a((double)delta, (double)-1.0, (double)1.0));
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int button) {
        return this.suggestions != null && this.suggestions.handleMouseClick((int)mouseX, (int)mouseY, button);
    }

    public void showSuggestions() {
        if (this.pendingSuggestions != null && this.pendingSuggestions.isDone()) {
            Suggestions suggestions = this.pendingSuggestions.join();
            if (suggestions.isEmpty()) {
                return;
            }
            List<Suggestion> filteredSuggestions = this.sortSuggestions(suggestions);
            if (!filteredSuggestions.isEmpty()) {
                int maxWidth = suggestions.getList().stream().mapToInt(suggestion -> this.fontRenderer.func_78256_a(suggestion.getText())).max().orElse(0);
                int x = MathHelper.func_76125_a((int)((GuiTextFieldExtras)this.input).brigo$screenX(suggestions.getRange().getStart()), (int)0, (int)(this.screen.field_146294_l - maxWidth));
                int y = this.config.anchorToBottom ? this.screen.field_146295_m - 12 : 72;
                this.suggestions = new SuggestionsList(x, y, maxWidth, filteredSuggestions);
            }
        }
    }

    private List<Suggestion> sortSuggestions(Suggestions suggestions) {
        String inputText = this.input.func_146179_b().substring(0, this.input.func_146198_h());
        int lastWordIndex = CommandSuggestions.findLastWordIndex(inputText);
        String currentWord = inputText.substring(lastWordIndex).toLowerCase(Locale.ROOT);
        ArrayList prioritySuggestions = Lists.newArrayList();
        ArrayList otherSuggestions = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            String text = suggestion.getText();
            if (text.equals(currentWord)) continue;
            if (text.startsWith(currentWord) || text.startsWith("minecraft:" + currentWord)) {
                prioritySuggestions.add(suggestion);
                continue;
            }
            otherSuggestions.add(suggestion);
        }
        prioritySuggestions.addAll(otherSuggestions);
        return prioritySuggestions;
    }

    public void updateCommandInfo() {
        boolean hasCommandPrefix;
        String text = this.input.func_146179_b();
        if (this.currentParse != null && !this.currentParse.getReader().getString().equals(text)) {
            this.currentParse = null;
        }
        if (!this.keepSuggestions) {
            ((GuiTextFieldExtras)this.input).brigo$suggestion(null);
            this.suggestions = null;
        }
        this.commandUsage.clear();
        StringReader reader = new StringReader(text);
        boolean bl = hasCommandPrefix = reader.canRead() && reader.peek() == '/';
        if (hasCommandPrefix) {
            reader.skip();
        }
        boolean isCommand = this.config.commandsOnly || hasCommandPrefix;
        int cursorPos = this.input.func_146198_h();
        if (isCommand) {
            this.processCommandSuggestions(reader, cursorPos);
        } else {
            this.processPlayerNameSuggestions(text, cursorPos);
        }
    }

    private void processCommandSuggestions(StringReader reader, int cursorPos) {
        int minCursor;
        CommandDispatcher<ISuggestionProvider> dispatcher = ((NetHandlerPlayClientExtras)this.minecraft.field_71439_g.field_71174_a).brigo$commands();
        if (this.currentParse == null) {
            ClientSuggestionProvider provider = ((NetHandlerPlayClientExtras)this.minecraft.field_71439_g.field_71174_a).brigo$suggestionsProvider();
            this.currentParse = dispatcher.parse(reader, (ISuggestionProvider)provider);
        }
        int n = minCursor = this.config.onlyShowIfCursorPastError ? reader.getCursor() : 1;
        if (!(cursorPos < minCursor || this.suggestions != null && this.keepSuggestions)) {
            this.pendingSuggestions = dispatcher.getCompletionSuggestions(this.currentParse, cursorPos);
            this.pendingSuggestions.thenRun(() -> {
                if (this.pendingSuggestions.isDone()) {
                    this.updateUsageInfo();
                }
            });
        }
    }

    private void processPlayerNameSuggestions(String text, int cursorPos) {
        String textToCursor = text.substring(0, cursorPos);
        int lastWordIndex = CommandSuggestions.findLastWordIndex(textToCursor);
        Collection<String> playerNames = ((NetHandlerPlayClientExtras)this.minecraft.field_71439_g.field_71174_a).brigo$suggestionsProvider().getPlayerNames();
        this.pendingSuggestions = ISuggestionProvider.suggest(playerNames, new SuggestionsBuilder(textToCursor, lastWordIndex));
    }

    private static int findLastWordIndex(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return 0;
        }
        int lastIndex = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(text);
        while (matcher.find()) {
            lastIndex = matcher.end();
        }
        return lastIndex;
    }

    private void updateUsageInfo() {
        if (this.input.func_146198_h() == this.input.func_146179_b().length()) {
            this.processParsingErrors();
        }
        this.commandUsagePosition = 0;
        this.commandUsageWidth = this.screen.field_146294_l;
        if (this.commandUsage.isEmpty()) {
            this.fillNodeUsage(TextFormatting.GRAY);
        }
        this.suggestions = null;
        if (this.allowSuggestions) {
            this.showSuggestions();
        }
    }

    private void processParsingErrors() {
        CommandSyntaxException parseException;
        if (this.pendingSuggestions.join().isEmpty() && !this.currentParse.getExceptions().isEmpty()) {
            int literalErrors = 0;
            for (Map.Entry<CommandNode<ISuggestionProvider>, CommandSyntaxException> entry : this.currentParse.getExceptions().entrySet()) {
                CommandSyntaxException exception = entry.getValue();
                if (exception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                    ++literalErrors;
                    continue;
                }
                this.commandUsage.add(CommandSuggestions.formatException(exception));
            }
            if (literalErrors > 0) {
                this.commandUsage.add(CommandSuggestions.formatException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
            }
        } else if (this.currentParse.getReader().canRead() && (parseException = CommandSuggestions.getParseException(this.currentParse)) != null) {
            this.commandUsage.add(CommandSuggestions.formatException(parseException));
        }
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> result) {
        if (!result.getReader().canRead()) {
            return null;
        }
        if (result.getExceptions().size() == 1) {
            return result.getExceptions().values().iterator().next();
        }
        if (result.getContext().getRange().isEmpty()) {
            return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(result.getReader());
        }
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(result.getReader());
    }

    private void fillNodeUsage(TextFormatting color) {
        CommandContextBuilder<ISuggestionProvider> context = this.currentParse.getContext();
        SuggestionContext<ISuggestionProvider> suggestionContext = context.findSuggestionContext(this.input.func_146198_h());
        CommandDispatcher<ISuggestionProvider> dispatcher = ((NetHandlerPlayClientExtras)this.minecraft.field_71439_g.field_71174_a).brigo$commands();
        ClientSuggestionProvider provider = ((NetHandlerPlayClientExtras)this.minecraft.field_71439_g.field_71174_a).brigo$suggestionsProvider();
        Map<CommandNode<ISuggestionProvider>, String> usageMap = dispatcher.getSmartUsage(suggestionContext.parent, provider);
        ArrayList usageList = Lists.newArrayList();
        int maxWidth = 0;
        for (Map.Entry<CommandNode<ISuggestionProvider>, String> entry : usageMap.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            String usage = color + entry.getValue();
            usageList.add(usage);
            maxWidth = Math.max(maxWidth, this.fontRenderer.func_78256_a(entry.getValue()));
        }
        if (!usageList.isEmpty()) {
            this.commandUsage.addAll(usageList);
            this.commandUsagePosition = MathHelper.func_76125_a((int)((GuiTextFieldExtras)this.input).brigo$screenX(suggestionContext.startPos), (int)0, (int)(this.screen.field_146294_l - maxWidth));
            this.commandUsageWidth = maxWidth;
        }
    }

    private String formatCommandText(String text, int offset) {
        return this.currentParse != null ? CommandSuggestions.formatParsedCommand(this.currentParse, text, offset) : text;
    }

    @Nullable
    static String calculateSuggestionSuffix(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    private static String formatException(CommandSyntaxException exception) {
        ITextComponent component = ComponentUtils.fromMessage(exception.getRawMessage());
        String context = exception.getContext();
        if (context == null) {
            return component.func_150254_d();
        }
        return new TextComponentString(String.format("%s at position %s: %s", component.func_150254_d(), exception.getCursor(), context)).func_150254_d();
    }

    private static String formatParsedCommand(ParseResults<ISuggestionProvider> parseResults, String command, int maxLength) {
        int errorStart;
        String grayCode = TextFormatting.GRAY.toString();
        StringBuilder result = new StringBuilder(grayCode);
        int currentPos = 0;
        int colorIndex = -1;
        CommandContextBuilder<ISuggestionProvider> context = parseResults.getContext().getLastChild();
        for (ParsedArgument<ISuggestionProvider, ?> argument : context.getArguments().values()) {
            colorIndex = (colorIndex + 1) % ARGUMENT_COLORS.length;
            int start = Math.max(argument.getRange().getStart() - maxLength, 0);
            if (start >= command.length()) break;
            int end = Math.min(argument.getRange().getEnd() - maxLength, command.length());
            if (end <= 0) continue;
            result.append(command, currentPos, start);
            result.append(ARGUMENT_COLORS[colorIndex]);
            result.append(command, start, end);
            result.append(grayCode);
            currentPos = end;
        }
        if (parseResults.getReader().canRead() && (errorStart = Math.max(parseResults.getReader().getCursor() - maxLength, 0)) < command.length()) {
            int errorEnd = Math.min(errorStart + parseResults.getReader().getRemainingLength(), command.length());
            result.append(command, currentPos, errorStart);
            result.append(TextFormatting.RED);
            result.append(command, errorStart, errorEnd);
            currentPos = errorEnd;
        }
        result.append(command, currentPos, command.length());
        return result.toString();
    }

    public void render(int mouseX, int mouseY) {
        if (this.suggestions != null) {
            this.suggestions.render(mouseX, mouseY);
        } else {
            this.renderUsageInfo();
        }
    }

    private void renderUsageInfo() {
        for (int i = 0; i < this.commandUsage.size(); ++i) {
            String usage = this.commandUsage.get(i);
            int y = this.config.anchorToBottom ? this.screen.field_146295_m - 14 - 13 - 12 * i : 72 + 12 * i;
            Gui.func_73734_a((int)(this.commandUsagePosition - 1), (int)y, (int)(this.commandUsagePosition + this.commandUsageWidth + 1), (int)(y + 12), (int)this.config.fillColor);
            this.fontRenderer.func_175063_a(usage, (float)this.commandUsagePosition, (float)(y + 2), -1);
        }
    }

    public class SuggestionsList {
        private final Rect2i bounds;
        private final String originalText;
        private final List<Suggestion> suggestions;
        private int scrollOffset;
        private int selectedIndex;
        private Vec2f lastMousePos = Vec2f.field_189974_a;
        private boolean tabCycles;

        SuggestionsList(int x, int y, int width, List<Suggestion> suggestions) {
            int actualY = ((CommandSuggestions)CommandSuggestions.this).config.anchorToBottom ? y - 3 - Math.min(suggestions.size(), ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit) * 12 : y;
            this.bounds = new Rect2i(x - 1, actualY, width + 1, Math.min(suggestions.size(), ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit) * 12);
            this.originalText = CommandSuggestions.this.input.func_146179_b();
            this.suggestions = suggestions;
            this.select(0);
        }

        public void render(int mouseX, int mouseY) {
            boolean hasMouseMoved;
            int visibleCount = Math.min(this.suggestions.size(), ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit);
            boolean hasScrollUp = this.scrollOffset > 0;
            boolean hasScrollDown = this.suggestions.size() > this.scrollOffset + visibleCount;
            boolean bl = hasMouseMoved = this.lastMousePos.field_189982_i != (float)mouseX || this.lastMousePos.field_189983_j != (float)mouseY;
            if (hasMouseMoved) {
                this.lastMousePos = new Vec2f((float)mouseX, (float)mouseY);
            }
            this.renderScrollIndicators(hasScrollUp, hasScrollDown);
            this.renderSuggestions(mouseX, mouseY, visibleCount, hasMouseMoved);
        }

        private void renderScrollIndicators(boolean hasScrollUp, boolean hasScrollDown) {
            if (hasScrollUp || hasScrollDown) {
                int i;
                Gui.func_73734_a((int)this.bounds.x(), (int)(this.bounds.y() - 1), (int)this.bounds.right(), (int)this.bounds.y(), (int)((CommandSuggestions)CommandSuggestions.this).config.fillColor);
                Gui.func_73734_a((int)this.bounds.x(), (int)this.bounds.bottom(), (int)this.bounds.right(), (int)(this.bounds.bottom() + 1), (int)((CommandSuggestions)CommandSuggestions.this).config.fillColor);
                if (hasScrollUp) {
                    for (i = 0; i < this.bounds.width(); i += 2) {
                        Gui.func_73734_a((int)(this.bounds.x() + i), (int)(this.bounds.y() - 1), (int)(this.bounds.x() + i + 1), (int)this.bounds.y(), (int)-1);
                    }
                }
                if (hasScrollDown) {
                    for (i = 0; i < this.bounds.width(); i += 2) {
                        Gui.func_73734_a((int)(this.bounds.x() + i), (int)this.bounds.bottom(), (int)(this.bounds.x() + i + 1), (int)(this.bounds.bottom() + 1), (int)-1);
                    }
                }
            }
        }

        private void renderSuggestions(int mouseX, int mouseY, int visibleCount, boolean hasMouseMoved) {
            Message tooltip;
            boolean showTooltip = false;
            for (int i = 0; i < visibleCount; ++i) {
                boolean isHovered;
                Suggestion suggestion = this.suggestions.get(i + this.scrollOffset);
                int itemY = this.bounds.y() + 12 * i;
                Gui.func_73734_a((int)this.bounds.x(), (int)itemY, (int)this.bounds.right(), (int)(itemY + 12), (int)((CommandSuggestions)CommandSuggestions.this).config.fillColor);
                boolean bl = isHovered = mouseX > this.bounds.x() && mouseX < this.bounds.right() && mouseY > itemY && mouseY < itemY + 12;
                if (isHovered) {
                    if (hasMouseMoved) {
                        this.select(i + this.scrollOffset);
                    }
                    showTooltip = true;
                }
                int textColor = i + this.scrollOffset == this.selectedIndex ? -256 : -5592406;
                CommandSuggestions.this.fontRenderer.func_175063_a(suggestion.getText(), (float)(this.bounds.x() + 1), (float)(itemY + 2), textColor);
            }
            if (showTooltip && (tooltip = this.suggestions.get(this.selectedIndex).getTooltip()) != null) {
                CommandSuggestions.this.screen.func_146279_a(ComponentUtils.fromMessage(tooltip).func_150254_d(), mouseX, mouseY);
            }
        }

        public boolean handleMouseClick(int mouseX, int mouseY, int button) {
            if (!this.bounds.contains(mouseX, mouseY)) {
                return false;
            }
            int clickedIndex = (mouseY - this.bounds.y()) / 12 + this.scrollOffset;
            if (clickedIndex >= 0 && clickedIndex < this.suggestions.size()) {
                this.select(clickedIndex);
                this.applySuggestion();
            }
            return true;
        }

        public boolean handleMouseScroll(double delta) {
            int mouseY;
            ScaledResolution resolution = new ScaledResolution(CommandSuggestions.this.minecraft);
            int mouseX = Mouse.getX() * resolution.func_78326_a() / ((CommandSuggestions)CommandSuggestions.this).minecraft.field_71443_c;
            if (this.bounds.contains(mouseX, mouseY = resolution.func_78328_b() - Mouse.getY() * resolution.func_78328_b() / ((CommandSuggestions)CommandSuggestions.this).minecraft.field_71440_d - 1)) {
                this.scrollOffset = MathHelper.func_76125_a((int)((int)((double)this.scrollOffset - delta)), (int)0, (int)Math.max(this.suggestions.size() - ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit, 0));
                return true;
            }
            return false;
        }

        public boolean handleKeyPress(int keyCode) {
            switch (keyCode) {
                case 200: {
                    this.cycle(-1);
                    this.tabCycles = false;
                    return true;
                }
                case 208: {
                    this.cycle(1);
                    this.tabCycles = false;
                    return true;
                }
                case 15: {
                    if (this.tabCycles) {
                        this.cycle(GuiScreen.func_146272_n() ? -1 : 1);
                    }
                    this.applySuggestion();
                    return true;
                }
                case 1: {
                    this.hide();
                    return true;
                }
            }
            return false;
        }

        public void cycle(int direction) {
            this.select(this.selectedIndex + direction);
            this.updateScrollOffset();
        }

        private void updateScrollOffset() {
            int visibleStart = this.scrollOffset;
            int visibleEnd = this.scrollOffset + ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit - 1;
            if (this.selectedIndex < visibleStart) {
                this.scrollOffset = MathHelper.func_76125_a((int)this.selectedIndex, (int)0, (int)Math.max(this.suggestions.size() - ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit, 0));
            } else if (this.selectedIndex > visibleEnd) {
                this.scrollOffset = MathHelper.func_76125_a((int)(this.selectedIndex + ((CommandSuggestions)CommandSuggestions.this).config.lineStartOffset - ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit), (int)0, (int)Math.max(this.suggestions.size() - ((CommandSuggestions)CommandSuggestions.this).config.suggestionLineLimit, 0));
            }
        }

        public void select(int index) {
            this.selectedIndex = (index % this.suggestions.size() + this.suggestions.size()) % this.suggestions.size();
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            String suffix = CommandSuggestions.calculateSuggestionSuffix(CommandSuggestions.this.input.func_146179_b(), suggestion.apply(this.originalText));
            ((GuiTextFieldExtras)CommandSuggestions.this.input).brigo$suggestion(suffix);
        }

        public void applySuggestion() {
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CommandSuggestions.this.keepSuggestions = true;
            String newText = suggestion.apply(this.originalText);
            CommandSuggestions.this.input.func_146180_a(newText);
            int cursorPos = suggestion.getRange().getStart() + suggestion.getText().length();
            CommandSuggestions.this.input.func_146190_e(cursorPos);
            CommandSuggestions.this.input.func_146199_i(cursorPos);
            this.select(this.selectedIndex);
            CommandSuggestions.this.keepSuggestions = false;
            this.tabCycles = true;
        }

        public void hide() {
            this.suggestions.clear();
            CommandSuggestions.this.suggestions = null;
        }
    }

    public static class CommandSuggestionsConfig {
        public final boolean commandsOnly;
        public final boolean onlyShowIfCursorPastError;
        public final int lineStartOffset;
        public final int suggestionLineLimit;
        public final boolean anchorToBottom;
        public final int fillColor;

        public CommandSuggestionsConfig(boolean commandsOnly, boolean onlyShowIfCursorPastError, int lineStartOffset, int suggestionLineLimit, boolean anchorToBottom, int fillColor) {
            this.commandsOnly = commandsOnly;
            this.onlyShowIfCursorPastError = onlyShowIfCursorPastError;
            this.lineStartOffset = lineStartOffset;
            this.suggestionLineLimit = suggestionLineLimit;
            this.anchorToBottom = anchorToBottom;
            this.fillColor = fillColor;
        }
    }
}

