/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.client;

import com.google.common.collect.Lists;
import dev.xhyrom.brigo.client.ISuggestionProvider;
import dev.xhyrom.brigo.shadow.brigadier.context.CommandContext;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestions;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketTabComplete;
import org.jetbrains.annotations.Nullable;

public class ClientSuggestionProvider
implements ISuggestionProvider {
    private final NetHandlerPlayClient connection;
    private final Minecraft mc;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestionsFuture;
    public static String command;

    public ClientSuggestionProvider(NetHandlerPlayClient connection, Minecraft mc) {
        this.connection = connection;
        this.mc = mc;
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList list = Lists.newArrayList();
        for (NetworkPlayerInfo networkPlayerInfo : this.connection.func_175106_d()) {
            list.add(networkPlayerInfo.func_178845_a().getName());
        }
        return list;
    }

    @Override
    public CompletableFuture<Suggestions> getSuggestionsFromServer(CommandContext<ISuggestionProvider> context, SuggestionsBuilder suggestionsBuilder) {
        if (this.pendingSuggestionsFuture != null) {
            this.pendingSuggestionsFuture.cancel(false);
        }
        this.pendingSuggestionsFuture = new CompletableFuture();
        command = context.getInput();
        this.connection.func_147297_a((Packet)new CPacketTabComplete(context.getInput(), null, false));
        return this.pendingSuggestionsFuture;
    }

    @Override
    public CompletableFuture<Suggestions> getSuggestionsFromServer() {
        if (this.pendingSuggestionsFuture != null) {
            this.pendingSuggestionsFuture.cancel(false);
        }
        this.pendingSuggestionsFuture = new CompletableFuture();
        command = "/";
        this.connection.func_147297_a((Packet)new CPacketTabComplete("/", null, false));
        return this.pendingSuggestionsFuture;
    }

    public void completeCustomSuggestions(Suggestions suggestions) {
        if (this.pendingSuggestionsFuture == null) {
            return;
        }
        this.pendingSuggestionsFuture.complete(suggestions);
        this.pendingSuggestionsFuture = null;
    }
}

