/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.block;

import biomesoplenty.common.block.IBOPBlock;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class BlockStateUtils {
    public static String getStateInfoAsString(IBlockState state) {
        String desc = state.func_177230_c().getClass().getName() + "[";
        UnmodifiableIterator it = state.func_177228_b().entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                desc = desc + ",";
            }
            Map.Entry entry = (Map.Entry)it.next();
            IProperty iproperty = (IProperty)entry.getKey();
            Comparable comparable = (Comparable)entry.getValue();
            desc = desc + iproperty.func_177701_a() + "=" + iproperty.func_177702_a(comparable);
            first = false;
        }
        desc = desc + "]";
        return desc;
    }

    public static ImmutableSet<IBlockState> getStatesSet(IBlockState baseState, IProperty ... properties) {
        Stack<IProperty> propStack = new Stack<IProperty>();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (IProperty prop : properties) {
            propStack.push(prop);
        }
        if (!propStack.isEmpty()) {
            BlockStateUtils.addStatesToList(baseState, states, propStack);
        }
        ImmutableSet ret = ImmutableSet.copyOf(states);
        return ret;
    }

    private static void addStatesToList(IBlockState state, List<IBlockState> list, Stack<IProperty> stack) {
        if (stack.empty()) {
            list.add(state);
            return;
        }
        IProperty prop = stack.pop();
        for (Object value : prop.func_177700_c()) {
            BlockStateUtils.addStatesToList(state.func_177226_a(prop, (Comparable)value), list, stack);
        }
        stack.push(prop);
    }

    public static ImmutableSet<IBlockState> getBlockPresets(Block block) {
        if (!(block instanceof IBOPBlock)) {
            return ImmutableSet.of();
        }
        IBlockState defaultState = block.func_176223_P();
        if (defaultState == null) {
            defaultState = block.func_176194_O().func_177621_b();
        }
        return BlockStateUtils.getStatesSet(defaultState, ((IBOPBlock)block).getPresetProperties());
    }

    public static IBlockState getPresetState(IBlockState state) {
        IBlockState outState = state.func_177230_c().func_176223_P();
        if (state.func_177230_c() instanceof IBOPBlock) {
            IBOPBlock bopBlock = (IBOPBlock)state.func_177230_c();
            for (IProperty property : bopBlock.getPresetProperties()) {
                outState = outState.func_177226_a(property, state.func_177229_b(property));
            }
        }
        return outState;
    }

    public static IProperty getPropertyByName(IBlockState blockState, String propertyName) {
        for (IProperty property : blockState.func_177228_b().keySet()) {
            if (!property.func_177701_a().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public static boolean isValidPropertyName(IBlockState blockState, String propertyName) {
        return BlockStateUtils.getPropertyByName(blockState, propertyName) != null;
    }

    public static Comparable getPropertyValueByName(IBlockState blockState, IProperty property, String valueName) {
        for (Comparable value : (ImmutableSet)property.func_177700_c()) {
            if (!value.toString().equals(valueName)) continue;
            return value;
        }
        return null;
    }
}

