/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.biome;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.common.util.block.BlockQuery;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class GeneratorUtils {
    public static Pair<Integer, Integer> validateMinMaxHeight(int minHeight, int maxHeight) {
        if (maxHeight < minHeight) {
            int prevMinHeight = minHeight;
            minHeight = maxHeight;
            maxHeight = prevMinHeight;
        }
        return Pair.of((Object)minHeight, (Object)maxHeight);
    }

    public static int safeNextInt(Random random, int i) {
        if (i <= 1) {
            return 0;
        }
        return random.nextInt(i);
    }

    public static int nextIntBetween(Random rand, int a, int b) {
        if (a == b) {
            return a;
        }
        int min = a < b ? a : b;
        int max = a > b ? a : b;
        return min + rand.nextInt(1 + max - min);
    }

    public static IBlockState deserializeStateNonNull(JsonObject json, String memberName, JsonDeserializationContext context) {
        IBlockState state = (IBlockState)context.deserialize(json.get(memberName), IBlockState.class);
        if (state == null) {
            throw new JsonSyntaxException("Property " + memberName + " doesn't exist");
        }
        return state;
    }

    public static BlockPos getFirstBlockMatching(World world, BlockPos startPos, IBlockPosQuery query) {
        BlockPos pos = startPos;
        while (pos.func_177956_o() > 0) {
            if (query.matches(world, pos)) {
                return pos;
            }
            pos = pos.func_177977_b();
        }
        return null;
    }

    public static IProperty getAxisProperty(IBlockState log) {
        for (Object property : log.func_177228_b().keySet()) {
            Collection allowedValues = ((IProperty)property).func_177700_c();
            if (!allowedValues.contains(BlockLog.EnumAxis.X) || !allowedValues.contains(BlockLog.EnumAxis.Y) || !allowedValues.contains(BlockLog.EnumAxis.Z)) continue;
            return (IProperty)property;
        }
        return null;
    }

    public static enum ScatterYMethod {
        ANYWHERE,
        NETHER_SURFACE,
        NETHER_ROOF,
        AT_SURFACE,
        AT_GROUND,
        BELOW_SURFACE,
        BELOW_GROUND,
        ABOVE_SURFACE,
        ABOVE_GROUND;


        public BlockPos getBlockPos(World world, Random random, int x, int z) {
            switch (this) {
                case AT_SURFACE: {
                    BlockPos pos = GeneratorUtils.getFirstBlockMatching(world, new BlockPos(x, 255, z), BlockQueries.surfaceBlocks);
                    return pos == null ? new BlockPos(x, 1, z) : pos.func_177984_a();
                }
                case AT_GROUND: {
                    BlockPos pos = GeneratorUtils.getFirstBlockMatching(world, new BlockPos(x, 255, z), BlockQueries.groundBlocks);
                    return pos == null ? new BlockPos(x, 1, z) : pos.func_177984_a();
                }
                case BELOW_SURFACE: {
                    int tempY = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
                    return new BlockPos(x, GeneratorUtils.nextIntBetween(random, 1, tempY - 1), z);
                }
                case BELOW_GROUND: {
                    int tempY = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
                    return new BlockPos(x, GeneratorUtils.nextIntBetween(random, 1, tempY - 1), z);
                }
                case ABOVE_SURFACE: {
                    int tempY = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
                    return new BlockPos(x, GeneratorUtils.nextIntBetween(random, tempY, 255), z);
                }
                case ABOVE_GROUND: {
                    int tempY = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
                    return new BlockPos(x, GeneratorUtils.nextIntBetween(random, tempY, 255), z);
                }
                case NETHER_SURFACE: {
                    int tempY = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
                    BlockPos pos = GeneratorUtils.getFirstBlockMatching(world, new BlockPos(x, GeneratorUtils.nextIntBetween(random, 1, 122), z), BlockQuery.buildAnd().add(BlockQueries.solid).withAirAbove().create());
                    return pos == null ? new BlockPos(x, 1, z) : pos.func_177984_a();
                }
                case NETHER_ROOF: {
                    int tempY = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
                    BlockPos pos = GeneratorUtils.getFirstBlockMatching(world, new BlockPos(x, GeneratorUtils.nextIntBetween(random, 1, 122), z), BlockQuery.buildAnd().add(BlockQueries.solid).withAirBelow().create());
                    return pos == null ? new BlockPos(x, 1, z) : pos.func_177977_b();
                }
            }
            return new BlockPos(x, GeneratorUtils.nextIntBetween(random, 1, 255), z);
        }
    }
}

